/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.TemporalType;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.GroupByConstantRenderingStrategy;
import org.hibernate.dialect.GroupBySummarizationRenderingStrategy;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLSqlAstTranslator;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.PostgreSQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.PostgresCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.cte.CteStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.PostgresUUIDType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.BlobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.ClobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;

public class PostgreSQLDialect
extends Dialect {
    private static final PostgreSQLIdentityColumnSupport IDENTITY_COLUMN_SUPPORT = new PostgreSQLIdentityColumnSupport();
    private final int version;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (Integer.parseInt(JdbcExceptionHelper.extractSqlState(sqle))) {
            case 23514: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates check constraint \"", "\"", sqle.getMessage());
            }
            case 23505: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates unique constraint \"", "\"", sqle.getMessage());
            }
            case 23503: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates foreign key constraint \"", "\"", sqle.getMessage());
            }
            case 23502: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("null value in column \"", "\" violates not-null constraint", sqle.getMessage());
            }
            case 23001: {
                return null;
            }
        }
        return null;
    });

    public PostgreSQLDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public PostgreSQLDialect() {
        this(800);
    }

    public PostgreSQLDialect(int version) {
        this.version = version;
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-3, "bytea");
        this.registerColumnType(-2, "bytea");
        this.registerColumnType(2004, "oid");
        this.registerColumnType(2005, "text");
        this.registerColumnType(-15, "char($l)");
        this.registerColumnType(-9, "varchar($l)");
        this.registerColumnType(-1, "text");
        this.registerColumnType(-16, "text");
        if (this.getVersion() >= 820) {
            this.registerColumnType(PostgresUUIDType.INSTANCE.getJdbcTypeDescriptor().getDefaultSqlTypeCode(), "uuid");
            if (this.getVersion() >= 920) {
                this.registerColumnType(2000, "json");
            }
        }
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", "true");
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String currentTime() {
        return "localtime";
    }

    @Override
    public String currentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType) {
        switch (unit) {
            case NANOSECOND: {
                return "(?3 + (?2)/1e3 * interval '1 microsecond')";
            }
            case NATIVE: {
                return "(?3 + (?2) * interval '1 second')";
            }
            case QUARTER: {
                return "(?3 + (?2) * interval '3 month')";
            }
            case WEEK: {
                return "(?3 + (?2) * interval '7 day')";
            }
        }
        return "(?3 + (?2) * interval '1 ?1')";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (toTemporalType != TemporalType.TIMESTAMP && fromTemporalType != TemporalType.TIMESTAMP && unit == TemporalUnit.DAY) {
            return "(?3-?2)";
        }
        StringBuilder pattern = new StringBuilder();
        switch (unit) {
            case YEAR: {
                this.extractField(pattern, TemporalUnit.YEAR, fromTemporalType, toTemporalType, unit);
                break;
            }
            case QUARTER: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, fromTemporalType, toTemporalType, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.QUARTER, fromTemporalType, toTemporalType, unit);
                pattern.append(")");
                break;
            }
            case MONTH: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, fromTemporalType, toTemporalType, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.MONTH, fromTemporalType, toTemporalType, unit);
                pattern.append(")");
                break;
            }
            case WEEK: 
            case DAY: {
                this.extractField(pattern, TemporalUnit.DAY, fromTemporalType, toTemporalType, unit);
                break;
            }
            case NANOSECOND: 
            case NATIVE: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                this.extractField(pattern, TemporalUnit.EPOCH, fromTemporalType, toTemporalType, unit);
                break;
            }
            default: {
                throw new SemanticException("unrecognized field: " + (Object)((Object)unit));
            }
        }
        return pattern.toString();
    }

    protected void extractField(StringBuilder pattern, TemporalUnit unit, TemporalType fromTimestamp, TemporalType toTimestamp, TemporalUnit toUnit) {
        pattern.append("extract(");
        pattern.append(this.translateDurationField(unit));
        pattern.append(" from ");
        if (toTimestamp != TemporalType.TIMESTAMP && fromTimestamp != TemporalType.TIMESTAMP) {
            pattern.append("age(?3,?2)");
        } else {
            switch (unit) {
                case QUARTER: 
                case YEAR: 
                case MONTH: {
                    pattern.append("age(?3,?2)");
                    break;
                }
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case EPOCH: {
                    pattern.append("?3-?2");
                    break;
                }
                default: {
                    throw new SemanticException((Object)((Object)unit) + " is not a legal field");
                }
            }
        }
        pattern.append(")").append(unit.conversionFactor(toUnit, this));
    }

    @Override
    public boolean supportsTimezoneTypes() {
        return true;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.cbrt(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.md5(queryEngine);
        CommonFunctionFactory.initcap(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.toCharNumberDateTimestamp(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.localtimeLocaltimestamp(queryEngine);
        CommonFunctionFactory.dateTrunc(queryEngine);
        CommonFunctionFactory.bitLength(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.char_chr(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.bitandorxornot_operator(queryEngine);
        CommonFunctionFactory.bitAndOr(queryEngine);
        CommonFunctionFactory.everyAny_boolAndOr(queryEngine);
        CommonFunctionFactory.median_percentileCont(queryEngine, false);
        CommonFunctionFactory.stddev(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.variance(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.covarPopSamp(queryEngine);
        CommonFunctionFactory.corr(queryEngine);
        CommonFunctionFactory.regrLinearRegressionAggregates(queryEngine);
        CommonFunctionFactory.insert_overlay(queryEngine);
        CommonFunctionFactory.overlay(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", StandardBasicTypes.INTEGER, "position(?1 in ?2)", "(position(?1 in substring(?2 from ?3)) + (?3) - 1)").setArgumentListSignature("(pattern, string[, start])");
        if (this.getVersion() >= 940) {
            CommonFunctionFactory.makeDateTimeTimestamp(queryEngine);
        }
    }

    @Override
    public JdbcTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        switch (sqlCode) {
            case 2004: {
                return BlobTypeDescriptor.BLOB_BINDING;
            }
            case 2005: {
                return ClobTypeDescriptor.CLOB_BINDING;
            }
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.getVersion() >= 820;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion() >= 900;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.getVersion() >= 920;
    }

    @Override
    public boolean supportsValuesList() {
        return this.getVersion() >= 820;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getVersion() >= 820;
    }

    @Override
    public boolean supportsPartitionBy() {
        return this.getVersion() >= 910;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return this.getVersion() >= 910;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion() < 820 ? PostgreSQLSequenceSupport.LEGACY_INSTANCE : PostgreSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.getVersion() < 840 ? LimitOffsetLimitHandler.INSTANCE : OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode;
        if (aliases.isEmpty()) {
            lockMode = lockOptions.getLockMode();
            Iterator<Map.Entry<String, LockMode>> itr = lockOptions.getAliasLockIterator();
            while (itr.hasNext()) {
                Map.Entry<String, LockMode> entry = itr.next();
                LockMode lm = entry.getValue();
                if (!lm.greaterThan(lockMode)) continue;
                aliases = entry.getKey();
            }
        }
        if ((lockMode = lockOptions.getAliasSpecificLockMode(aliases)) == null) {
            lockMode = lockOptions.getLockMode();
        }
        switch (lockMode) {
            case UPGRADE: {
                return this.getForUpdateString(aliases);
            }
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, lockOptions.getTimeOut());
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, lockOptions.getTimeOut());
            }
            case UPGRADE_NOWAIT: 
            case FORCE: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        return "null::" + this.getRawTypeName(sqlType);
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return String.valueOf(bool);
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new PostgreSQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (JdbcExceptionHelper.extractSqlState(sqlException)) {
                case "40P01": {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case "55P03": {
                    return new PessimisticLockException(message, sqlException, sql);
                }
            }
            return null;
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 1111);
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return true;
    }

    @Override
    public boolean supportsSelectAliasInGroupByClause() {
        return true;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return PostgresCallableStatementSupport.INSTANCE;
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        if (position != 1) {
            throw new UnsupportedOperationException("PostgreSQL only supports REF_CURSOR parameters as the first parameter");
        }
        return (ResultSet)statement.getObject(1);
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL only supports accessing REF_CURSOR parameters by position");
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return IDENTITY_COLUMN_SUPPORT;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return this.datetimeFormat(format).result();
    }

    public Replacer datetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, true, false).replace("SSSSSS", "US").replace("SSSSS", "US").replace("SSSS", "US").replace("SSS", "MS").replace("SS", "MS").replace("S", "MS").replace("ee", "ID").replace("e", "fmID").replace("zzz", "TZ").replace("zz", "TZ").replace("z", "TZ").replace("xxx", "OF").replace("xx", "OF").replace("x", "OF");
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String formatBinaryLiteral(byte[] bytes) {
        return "bytea '\\x" + StandardBasicTypes.BINARY.toString(bytes) + "'";
    }

    @Override
    protected String wrapDateLiteral(String date) {
        return DateTimeUtils.wrapAsAnsiDateLiteral(date);
    }

    @Override
    protected String wrapTimeLiteral(String time) {
        return DateTimeUtils.wrapAsAnsiTimeLiteral(time);
    }

    @Override
    protected String wrapTimestampLiteral(String timestamp) {
        return "timestamp with time zone '" + timestamp + "'";
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
        }
        return lockString;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? " for update of " + aliases + " nowait" : this.getForUpdateString(aliases);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? " for update of " + aliases + " skip locked" : this.getForUpdateString(aliases);
    }

    @Override
    public boolean supportsNoWait() {
        return this.getVersion() >= 810;
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getVersion() >= 950;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        switch (type) {
            case ROWS_ONLY: {
                return this.getVersion() >= 840;
            }
            case PERCENT_ONLY: 
            case PERCENT_WITH_TIES: {
                return false;
            }
            case ROWS_WITH_TIES: {
                return this.getVersion() >= 1300;
            }
        }
        return false;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    @Override
    public GroupBySummarizationRenderingStrategy getGroupBySummarizationRenderingStrategy() {
        return this.getVersion() >= 950 ? GroupBySummarizationRenderingStrategy.FUNCTION : GroupBySummarizationRenderingStrategy.NONE;
    }

    @Override
    public GroupByConstantRenderingStrategy getGroupByConstantRenderingStrategy() {
        return this.getVersion() >= 950 ? GroupByConstantRenderingStrategy.EMPTY_GROUPING : GroupByConstantRenderingStrategy.SUBQUERY;
    }

    @Override
    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
        super.augmentRecognizedTableTypes(tableTypesList);
        if (this.getVersion() >= 930) {
            tableTypesList.add("MATERIALIZED VIEW");
            if (this.getVersion() >= 1000) {
                tableTypesList.add("PARTITIONED TABLE");
            }
        }
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        if (this.getVersion() >= 820) {
            typeContributions.contributeType(PostgresUUIDType.INSTANCE);
        }
    }
}

