/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.persistence.TemporalType;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.SybaseSqlAstTranslator;
import org.hibernate.dialect.SybaseSqmToSqlAstConverter;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.CastType;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.jdbc.BlobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.ClobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.NClobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeDescriptorRegistry;

public class SybaseDialect
extends AbstractTransactSQLDialect {
    private final int version;
    protected final boolean jtdsDriver;
    private static final int PARAM_LIST_SIZE_LIMIT = 250000;

    public SybaseDialect() {
        this(1100, false);
    }

    public SybaseDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10, info.getDriverName() != null && info.getDriverName().contains("jTDS"));
    }

    public SybaseDialect(int version, boolean jtdsDriver) {
        this.version = version;
        this.jtdsDriver = jtdsDriver;
        this.registerColumnType(-5, "numeric(19,0)");
    }

    @Override
    public JdbcTypeDescriptor resolveSqlTypeDescriptor(int jdbcTypeCode, int precision, int scale, JdbcTypeDescriptorRegistry jdbcTypeDescriptorRegistry) {
        switch (jdbcTypeCode) {
            case 2: 
            case 3: {
                if (precision != 19 || scale != 0) break;
                return jdbcTypeDescriptorRegistry.getDescriptor(-5);
            }
        }
        return super.resolveSqlTypeDescriptor(jdbcTypeCode, precision, scale, jdbcTypeDescriptorRegistry);
    }

    @Override
    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            @Override
            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext) {
                return new SybaseSqmToSqlAstConverter<SelectStatement>(sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext);
            }
        };
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 250000;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        if (this.jtdsDriver) {
            typeContributions.getTypeConfiguration().getJdbcTypeDescriptorRegistry().addDescriptor(2011, ClobTypeDescriptor.CLOB_BINDING);
            typeContributions.getTypeConfiguration().getJdbcTypeDescriptorRegistry().addDescriptor(-9, ClobTypeDescriptor.CLOB_BINDING);
            typeContributions.contributeJdbcTypeDescriptor(ClobTypeDescriptor.CLOB_BINDING);
        }
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return this.jtdsDriver ? NationalizationSupport.IMPLICIT : super.getNationalizationSupport();
    }

    @Override
    protected JdbcTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        switch (sqlCode) {
            case 2004: {
                return BlobTypeDescriptor.PRIMITIVE_ARRAY_BINDING;
            }
            case 2005: {
                return this.jtdsDriver ? ClobTypeDescriptor.CLOB_BINDING : ClobTypeDescriptor.STREAM_BINDING_EXTRACTING;
            }
            case 2011: {
                if (this.jtdsDriver) {
                    return NClobTypeDescriptor.NCLOB_BINDING;
                }
            }
            case -9: {
                if (!this.jtdsDriver) break;
                return NClobTypeDescriptor.NCLOB_BINDING;
            }
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.locate_charindex(queryEngine);
        CommonFunctionFactory.replace_strReplace(queryEngine);
        CommonFunctionFactory.everyAny_sumCaseCase(queryEngine);
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select db_name()";
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case DATE: {
                    return "str_replace(convert(varchar, ?1, 102), '.', '-')";
                }
                case TIME: {
                    return "convert(varchar, ?1, 108)";
                }
                case TIMESTAMP: {
                    return "str_replace(convert(varchar, ?1, 23), 'T', ' ')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "calweekofyear";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return "datepart(?1, ?2)";
    }

    @Override
    public boolean supportsFractionalTimestampArithmetic() {
        return false;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType) {
        return "dateadd(?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "datediff(?1, ?2, ?3)";
    }

    @Override
    public String trimPattern(TrimSpec specification, char character) {
        return super.trimPattern(specification, character).replace("replace", "str_replace");
    }

    @Override
    public String translateDatetimeFormat(String format) {
        throw new NotYetImplementedFor6Exception("format() function not supported on Sybase");
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }
}

