/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import javax.persistence.TemporalType;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2FormatEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public DB2FormatEmulation() {
        super("format", StandardArgumentsValidators.exactly(2), StandardFunctionReturnTypeResolvers.invariant(StandardBasicTypes.STRING));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        Expression datetime = (Expression)arguments.get(0);
        boolean isTime = TypeConfiguration.getSqlTemporalType(datetime.getExpressionType()) == TemporalType.TIME;
        Format format = (Format)arguments.get(1);
        sqlAppender.appendSql("(");
        String[] bits = OracleDialect.datetimeFormat(format.getFormat(), false, false).result().split("\"");
        boolean first = true;
        for (int i = 0; i < bits.length; ++i) {
            String bit = bits[i];
            if (bit.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                sqlAppender.appendSql("||");
            }
            if (i % 2 == 0) {
                sqlAppender.appendSql("varchar_format(");
                if (isTime) {
                    sqlAppender.appendSql("timestamp(current_date,");
                    datetime.accept(walker);
                    sqlAppender.appendSql(")");
                } else {
                    datetime.accept(walker);
                }
                sqlAppender.appendSql(",'");
                sqlAppender.appendSql(bit);
                sqlAppender.appendSql("')");
                continue;
            }
            sqlAppender.appendSql("'");
            sqlAppender.appendSql(bit);
            sqlAppender.appendSql("'");
        }
        if (first) {
            sqlAppender.appendSql("''");
        }
        sqlAppender.appendSql(")");
    }

    @Override
    public String getArgumentListSignature() {
        return "(datetime as pattern)";
    }
}

