/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class InsertSubstringOverlayEmulation
extends AbstractSqmFunctionDescriptor {
    private final boolean strictSubstring;

    public InsertSubstringOverlayEmulation(boolean strictSubstring) {
        super("overlay", StandardArgumentsValidators.between(3, 4), StandardFunctionReturnTypeResolvers.invariant(StandardBasicTypes.STRING));
        this.strictSubstring = strictSubstring;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        BasicType<Integer> intType = typeConfiguration.getBasicTypeForJavaType(Integer.class);
        SqmTypedNode<?> string = arguments.get(0);
        SqmTypedNode<?> replacement = arguments.get(1);
        SqmTypedNode<?> start = arguments.get(2);
        SqmTypedNode<?> length = arguments.size() > 3 ? arguments.get(3) : queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("length").generateSqmExpression(replacement, intType, queryEngine, typeConfiguration);
        SqmFunctionDescriptor insert = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("insert");
        if (insert != null) {
            return insert.generateSqmExpression(Arrays.asList(string, start, length, replacement), impliedResultType, queryEngine, typeConfiguration);
        }
        SqmFunctionDescriptor lengthFunction = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("length");
        SqmFunctionDescriptor substring = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("substring");
        SqmFunctionDescriptor concat = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("concat");
        SqmLiteral<Integer> one = new SqmLiteral<Integer>(1, intType, queryEngine.getCriteriaBuilder());
        SqmBinaryArithmetic<Integer> startPlusLength = new SqmBinaryArithmetic<Integer>(BinaryArithmeticOperator.ADD, (SqmExpression)start, (SqmExpression)length, intType, (NodeBuilder)queryEngine.getCriteriaBuilder());
        SqmBinaryArithmetic<Integer> startMinusOne = new SqmBinaryArithmetic<Integer>(BinaryArithmeticOperator.SUBTRACT, (SqmExpression)start, one, intType, (NodeBuilder)queryEngine.getCriteriaBuilder());
        AllowableFunctionReturnType<T> stringType = impliedResultType;
        SqmTypedNode<T> restString = substring.generateSqmExpression(Arrays.asList(string, startPlusLength), impliedResultType, queryEngine, typeConfiguration);
        if (this.strictSubstring) {
            restString = (SqmTypedNode)new SqmCaseSearched<T>(stringType, start.nodeBuilder()).when((Expression)new SqmComparisonPredicate(startPlusLength, ComparisonOperator.GREATER_THAN, lengthFunction.generateSqmExpression(Arrays.asList(string), intType, queryEngine, typeConfiguration), string.nodeBuilder()), (Expression)new SqmLiteral<String>("", stringType, string.nodeBuilder())).otherwise((Expression)restString);
        }
        return concat.generateSqmExpression(Arrays.asList(substring.generateSqmExpression(Arrays.asList(string, one, startMinusOne), impliedResultType, queryEngine, typeConfiguration), replacement, restString), impliedResultType, queryEngine, typeConfiguration);
    }

    @Override
    public String getArgumentListSignature() {
        return "(string placing replacement from start[ for length])";
    }
}

