/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import javax.persistence.TemporalType;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerFormatEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final SQLServerDialect dialect;

    public SQLServerFormatEmulation(SQLServerDialect dialect) {
        super("format", StandardArgumentsValidators.exactly(2), StandardFunctionReturnTypeResolvers.invariant(StandardBasicTypes.STRING));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        Expression datetime = (Expression)arguments.get(0);
        boolean isTime = TypeConfiguration.getSqlTemporalType(datetime.getExpressionType()) == TemporalType.TIME;
        Format format = (Format)arguments.get(1);
        sqlAppender.appendSql("format(");
        if (isTime) {
            sqlAppender.appendSql("cast(");
            datetime.accept(walker);
            sqlAppender.appendSql(" as datetime)");
        } else {
            datetime.accept(walker);
        }
        sqlAppender.appendSql(",'");
        sqlAppender.appendSql(this.dialect.translateDatetimeFormat(format.getFormat()));
        sqlAppender.appendSql("')");
    }

    @Override
    public String getArgumentListSignature() {
        return "(datetime as pattern)";
    }
}

