/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampaddFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;
    private final CastFunction castFunction;

    public TimestampaddFunction(Dialect dialect) {
        super("timestampadd", StandardArgumentsValidators.exactly(3), StandardFunctionReturnTypeResolvers.useArgType(3));
        this.dialect = dialect;
        this.castFunction = new CastFunction(dialect, 16);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        TemporalUnit unit;
        DurationUnit field = (DurationUnit)arguments.get(0);
        Expression to = (Expression)arguments.get(2);
        if (this.dialect.supportsFractionalTimestampArithmetic()) {
            unit = field.getUnit();
        } else {
            Expression magnitude = (Expression)arguments.get(1);
            JdbcMapping magnitudeJdbcMapping = magnitude.getExpressionType().getJdbcMappings().get(0);
            switch (magnitudeJdbcMapping.getJdbcTypeDescriptor().getJdbcTypeCode()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    unit = field.getUnit();
                    break;
                }
                default: {
                    unit = magnitudeJdbcMapping.getMappedJavaTypeDescriptor().getJavaTypeClass() == Duration.class ? field.getUnit() : (field.getUnit() == TemporalUnit.SECOND ? TemporalUnit.NANOSECOND : TemporalUnit.SECOND);
                }
            }
        }
        String pattern = this.dialect.timestampaddPattern(unit, TypeConfiguration.getSqlTemporalType(to.getExpressionType()));
        PatternRenderer renderer = new PatternRenderer(pattern);
        if (unit != field.getUnit()) {
            ArrayList<SqlAstNode> castArguments = new ArrayList<SqlAstNode>(2);
            ArrayList<SqlAstNode> newArguments = new ArrayList<SqlAstNode>(arguments);
            Expression magnitude = (Expression)arguments.get(1);
            BasicValuedMapping expressionType = (BasicValuedMapping)magnitude.getExpressionType();
            String conversionFactor = field.getUnit().conversionFactor(unit, this.dialect);
            if (conversionFactor.isEmpty()) {
                castArguments.add(magnitude);
            } else {
                castArguments.add(new BinaryArithmeticExpression(magnitude, conversionFactor.charAt(0) == '*' ? BinaryArithmeticOperator.MULTIPLY : BinaryArithmeticOperator.DIVIDE, new QueryLiteral(expressionType.getExpressableJavaTypeDescriptor().fromString(conversionFactor.substring(1)), expressionType), expressionType));
            }
            castArguments.add(new CastTarget(StandardBasicTypes.INTEGER));
            newArguments.set(0, new DurationUnit(unit, field.getExpressionType()));
            newArguments.set(1, new SelfRenderingFunctionSqlAstExpression("cast", this.castFunction::render, castArguments, StandardBasicTypes.INTEGER, StandardBasicTypes.INTEGER));
            renderer.render(sqlAppender, newArguments, walker);
        } else {
            renderer.render(sqlAppender, arguments, walker);
        }
    }

    public SelfRenderingFunctionSqlAstExpression expression(AllowableFunctionReturnType<?> impliedResultType, SqlAstNode ... sqlAstArguments) {
        Expression to = (Expression)sqlAstArguments[2];
        return new SelfRenderingFunctionSqlAstExpression(this.getName(), this::render, Arrays.asList(sqlAstArguments), impliedResultType, to.getExpressionType());
    }

    @Override
    public String getArgumentListSignature() {
        return "(field, magnitude, datetime)";
    }
}

