/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.query.Limit;
import org.hibernate.query.spi.QueryOptions;

public interface LimitHandler {
    public boolean supportsLimit();

    public boolean supportsOffset();

    public boolean supportsLimitOffset();

    default public String processSql(String sql, Limit limit) {
        return this.processSql(sql, limit == null ? null : new RowSelection(limit.getFirstRow(), limit.getMaxRows(), null, null));
    }

    default public String processSql(String sql, Limit limit, QueryOptions queryOptions) {
        return this.processSql(sql, limit == null ? null : new RowSelection(limit.getFirstRow(), limit.getMaxRows(), null, null));
    }

    default public int bindLimitParametersAtStartOfQuery(Limit limit, PreparedStatement statement, int index) throws SQLException {
        return this.bindLimitParametersAtStartOfQuery(limit == null ? null : new RowSelection(limit.getFirstRow(), limit.getMaxRows(), null, null), statement, index);
    }

    default public int bindLimitParametersAtEndOfQuery(Limit limit, PreparedStatement statement, int index) throws SQLException {
        return this.bindLimitParametersAtEndOfQuery(limit == null ? null : new RowSelection(limit.getFirstRow(), limit.getMaxRows(), null, null), statement, index);
    }

    default public void setMaxRows(Limit limit, PreparedStatement statement) throws SQLException {
        this.setMaxRows(limit == null ? null : new RowSelection(limit.getFirstRow(), limit.getMaxRows(), null, null), statement);
    }

    @Deprecated
    public String processSql(String var1, RowSelection var2);

    @Deprecated
    default public String processSql(String sql, QueryParameters queryParameters) {
        return this.processSql(sql, queryParameters.getRowSelection());
    }

    @Deprecated
    public int bindLimitParametersAtStartOfQuery(RowSelection var1, PreparedStatement var2, int var3) throws SQLException;

    @Deprecated
    public int bindLimitParametersAtEndOfQuery(RowSelection var1, PreparedStatement var2, int var3) throws SQLException;

    @Deprecated
    public void setMaxRows(RowSelection var1, PreparedStatement var2) throws SQLException;
}

