/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.dialect.internal;

import java.util.Collection;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jdbc.dialect.internal.DialectResolverSet;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class DialectResolverInitiator
implements StandardServiceInitiator<DialectResolver> {
    public static final DialectResolverInitiator INSTANCE = new DialectResolverInitiator();

    @Override
    public Class<DialectResolver> getServiceInitiated() {
        return DialectResolver.class;
    }

    @Override
    public DialectResolver initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        DialectResolverSet resolverSet = new DialectResolverSet();
        this.applyCustomerResolvers(resolverSet, registry, configurationValues);
        resolverSet.addResolver(new StandardDialectResolver());
        return resolverSet;
    }

    private void applyCustomerResolvers(DialectResolverSet resolverSet, ServiceRegistryImplementor registry, Map<?, ?> configurationValues) {
        String resolverImplNames = (String)configurationValues.get("hibernate.dialect_resolvers");
        ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
        if (StringHelper.isNotEmpty(resolverImplNames)) {
            for (String resolverImplName : StringHelper.split(", \n\r\f\t", resolverImplNames)) {
                try {
                    resolverSet.addResolver((DialectResolver)classLoaderService.classForName(resolverImplName).newInstance());
                }
                catch (HibernateException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServiceException("Unable to instantiate named dialect resolver [" + resolverImplName + "]", e);
                }
            }
        }
        Collection<DialectResolver> resolvers = classLoaderService.loadJavaServices(DialectResolver.class);
        resolverSet.addDiscoveredResolvers(resolvers);
    }
}

