/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.FlushModeType;
import javax.persistence.TransactionRequiredException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryProducerImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public interface SharedSessionContractImplementor
extends SharedSessionContract,
JdbcSessionOwner,
TransactionCoordinatorBuilder.Options,
LobCreationContext,
WrapperOptions,
QueryProducerImplementor,
JavaTypeDescriptor.CoercionContext {
    @Override
    public SessionFactoryImplementor getFactory();

    @Override
    default public TypeConfiguration getTypeConfiguration() {
        return this.getFactory().getTypeConfiguration();
    }

    public SessionEventListenerManager getEventListenerManager();

    public PersistenceContext getPersistenceContext();

    public JdbcCoordinator getJdbcCoordinator();

    public JdbcServices getJdbcServices();

    @Override
    public String getTenantIdentifier();

    public UUID getSessionIdentifier();

    @Override
    default public SharedSessionContractImplementor getSession() {
        return this;
    }

    default public Object getSessionToken() {
        return this;
    }

    public boolean isClosed();

    default public boolean isOpenOrWaitingForAutoClose() {
        return !this.isClosed();
    }

    default public void checkOpen() {
        this.checkOpen(true);
    }

    public void checkOpen(boolean var1);

    public void prepareForQueryExecution(boolean var1);

    public void markForRollbackOnly();

    public long getTransactionStartTimestamp();

    @Deprecated
    default public long getTimestamp() {
        return this.getTransactionStartTimestamp();
    }

    public CacheTransactionSynchronization getCacheTransactionSynchronization();

    public boolean isTransactionInProgress();

    default public void checkTransactionNeededForUpdateOperation(String exceptionMessage) {
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException(exceptionMessage);
        }
    }

    public Transaction accessTransaction();

    public EntityKey generateEntityKey(Object var1, EntityPersister var2);

    public Interceptor getInterceptor();

    public void setAutoClear(boolean var1);

    public void initializeCollection(PersistentCollection var1, boolean var2) throws HibernateException;

    public Object internalLoad(String var1, Object var2, boolean var3, boolean var4) throws HibernateException;

    public Object immediateLoad(String var1, Object var2) throws HibernateException;

    public EntityPersister getEntityPersister(String var1, Object var2) throws HibernateException;

    public Object getEntityUsingInterceptor(EntityKey var1) throws HibernateException;

    public Object getContextEntityIdentifier(Object var1);

    public String bestGuessEntityName(Object var1);

    public String guessEntityName(Object var1) throws HibernateException;

    public Object instantiate(String var1, Object var2) throws HibernateException;

    public List list(NativeSQLQuerySpecification var1, QueryParameters var2) throws HibernateException;

    public ScrollableResultsImplementor scroll(NativeSQLQuerySpecification var1, QueryParameters var2);

    public int getDontFlushFromFind();

    public boolean isDefaultReadOnly();

    @Override
    public CacheMode getCacheMode();

    public void setCacheMode(CacheMode var1);

    @Deprecated
    public void setFlushMode(FlushMode var1);

    public FlushModeType getFlushMode();

    public void setHibernateFlushMode(FlushMode var1);

    @Override
    public FlushMode getHibernateFlushMode();

    public Connection connection();

    public void flush();

    public boolean isEventSource();

    public void afterScrollOperation();

    public boolean shouldAutoClose();

    public boolean isAutoCloseSessionEnabled();

    default public boolean isQueryParametersValidationEnabled() {
        return this.getFactory().getSessionFactoryOptions().isQueryParametersValidationEnabled();
    }

    public LoadQueryInfluencers getLoadQueryInfluencers();

    public ExceptionConverter getExceptionConverter();

    default public Integer getConfiguredJdbcBatchSize() {
        Integer sessionJdbcBatchSize = this.getJdbcBatchSize();
        return sessionJdbcBatchSize == null ? ConfigurationHelper.getInt("hibernate.jdbc.batch_size", this.getFactory().getProperties(), 1) : sessionJdbcBatchSize;
    }

    public PersistenceContext getPersistenceContextInternal();

    public boolean autoFlushIfRequired(Set<String> var1) throws HibernateException;

    default public boolean isEnforcingFetchGraph() {
        return false;
    }

    default public void setEnforcingFetchGraph(boolean enforcingFetchGraph) {
    }

    public void afterOperation(boolean var1);
}

