/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.util.Objects;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.SequenceMismatchStrategy;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.NoopOptimizer;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class SequenceStyleGenerator
implements PersistentIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SequenceStyleGenerator.class.getName());
    public static final String SEQUENCE_PARAM = "sequence_name";
    @Deprecated
    public static final String DEF_SEQUENCE_NAME = "hibernate_sequence";
    public static final String CONFIG_SEQUENCE_PER_ENTITY_SUFFIX = "sequence_per_entity_suffix";
    public static final String DEF_SEQUENCE_SUFFIX = "_SEQ";
    public static final String FORCE_TBL_PARAM = "force_table_use";
    public static final String VALUE_COLUMN_PARAM = "value_column";
    public static final String DEF_VALUE_COLUMN = "next_val";
    private DatabaseStructure databaseStructure;
    private Optimizer optimizer;
    private Type identifierType;

    public DatabaseStructure getDatabaseStructure() {
        return this.databaseStructure;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        String databaseSequenceName;
        Long databaseIncrementValue;
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
        Dialect dialect = jdbcEnvironment.getDialect();
        this.identifierType = type;
        boolean forceTableUse = ConfigurationHelper.getBoolean(FORCE_TBL_PARAM, params, false);
        QualifiedName sequenceName = this.determineSequenceName(params, dialect, jdbcEnvironment, serviceRegistry);
        int initialValue = this.determineInitialValue(params);
        int incrementSize = this.determineIncrementSize(params);
        String optimizationStrategy = this.determineOptimizationStrategy(params, incrementSize);
        boolean isPooledOptimizer = OptimizerFactory.isPooledOptimizer(optimizationStrategy);
        SequenceMismatchStrategy sequenceMismatchStrategy = configurationService.getSetting("hibernate.id.sequence.increment_size_mismatch_strategy", SequenceMismatchStrategy::interpret, SequenceMismatchStrategy.EXCEPTION);
        if (sequenceMismatchStrategy != SequenceMismatchStrategy.NONE && isPooledOptimizer && this.isPhysicalSequence(jdbcEnvironment, forceTableUse) && (databaseIncrementValue = this.getSequenceIncrementValue(jdbcEnvironment, databaseSequenceName = sequenceName.getObjectName().getText())) != null && !databaseIncrementValue.equals(incrementSize)) {
            int dbIncrementValue = databaseIncrementValue.intValue();
            switch (sequenceMismatchStrategy) {
                case EXCEPTION: {
                    throw new MappingException(String.format("The increment size of the [%s] sequence is set to [%d] in the entity mapping while the associated database sequence increment size is [%d].", databaseSequenceName, incrementSize, dbIncrementValue));
                }
                case FIX: {
                    incrementSize = dbIncrementValue;
                }
                case LOG: {
                    LOG.sequenceIncrementSizeMismatch(databaseSequenceName, incrementSize, dbIncrementValue);
                }
            }
        }
        incrementSize = this.determineAdjustedIncrementSize(optimizationStrategy, incrementSize);
        if (dialect.getSequenceSupport().supportsSequences() && !forceTableUse && !dialect.getSequenceSupport().supportsPooledSequences() && OptimizerFactory.isPooledOptimizer(optimizationStrategy)) {
            forceTableUse = true;
            LOG.forcingTableUse();
        }
        this.databaseStructure = this.buildDatabaseStructure(type, params, jdbcEnvironment, forceTableUse, sequenceName, initialValue, incrementSize);
        this.optimizer = OptimizerFactory.buildOptimizer(optimizationStrategy, this.identifierType.getReturnedClass(), incrementSize, ConfigurationHelper.getInt("initial_value", params, -1));
        this.databaseStructure.prepare(this.optimizer);
    }

    protected QualifiedName determineSequenceName(Properties params, Dialect dialect, JdbcEnvironment jdbcEnv, ServiceRegistry serviceRegistry) {
        Identifier catalog = jdbcEnv.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("catalog", params));
        Identifier schema = jdbcEnv.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("schema", params));
        String sequenceName = ConfigurationHelper.getString(SEQUENCE_PARAM, params);
        if (StringHelper.isNotEmpty(sequenceName)) {
            if (sequenceName.contains(".")) {
                return QualifiedNameParser.INSTANCE.parse(sequenceName);
            }
            return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnv.getIdentifierHelper().toIdentifier(sequenceName));
        }
        String implicitName = this.determineImplicitName(params, jdbcEnv, serviceRegistry);
        return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnv.getIdentifierHelper().toIdentifier(implicitName));
    }

    private String determineImplicitName(Properties params, JdbcEnvironment jdbcEnv, ServiceRegistry serviceRegistry) {
        String annotationGeneratorName = params.getProperty("GENERATOR_NAME");
        String base = ConfigurationHelper.getString("implicit_name_base", params);
        String suffix = ConfigurationHelper.getString(CONFIG_SEQUENCE_PER_ENTITY_SUFFIX, params, DEF_SEQUENCE_SUFFIX);
        if (!Objects.equals(suffix, DEF_SEQUENCE_SUFFIX) && StringHelper.isNotEmpty(base)) {
            if (Identifier.isQuoted(base)) {
                return "`" + Identifier.unQuote(base) + suffix + "`";
            }
            return base + suffix;
        }
        if (StringHelper.isNotEmpty(annotationGeneratorName)) {
            return annotationGeneratorName;
        }
        if (StringHelper.isNotEmpty(base)) {
            if (Identifier.isQuoted(base)) {
                return "`" + Identifier.unQuote(base) + suffix + "`";
            }
            return base + suffix;
        }
        throw new MappingException("Unable to determine sequence name");
    }

    protected Identifier determineValueColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString(VALUE_COLUMN_PARAM, params, DEF_VALUE_COLUMN);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name);
    }

    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt("initial_value", params, 1);
    }

    protected int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt("increment_size", params, 50);
    }

    protected String determineOptimizationStrategy(Properties params, int incrementSize) {
        return ConfigurationHelper.getString("optimizer", params, OptimizerFactory.determineImplicitOptimizerName(incrementSize, params));
    }

    protected int determineAdjustedIncrementSize(String optimizationStrategy, int incrementSize) {
        int resolvedIncrementSize;
        if (Math.abs(incrementSize) > 1 && StandardOptimizerDescriptor.NONE.getExternalName().equals(optimizationStrategy)) {
            if (incrementSize < -1) {
                resolvedIncrementSize = -1;
                LOG.honoringOptimizerSetting(StandardOptimizerDescriptor.NONE.getExternalName(), "increment_size", incrementSize, "negative", resolvedIncrementSize);
            } else {
                resolvedIncrementSize = 1;
                LOG.honoringOptimizerSetting(StandardOptimizerDescriptor.NONE.getExternalName(), "increment_size", incrementSize, "positive", resolvedIncrementSize);
            }
        } else {
            resolvedIncrementSize = incrementSize;
        }
        return resolvedIncrementSize;
    }

    protected DatabaseStructure buildDatabaseStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, boolean forceTableUse, QualifiedName sequenceName, int initialValue, int incrementSize) {
        if (this.isPhysicalSequence(jdbcEnvironment, forceTableUse)) {
            return this.buildSequenceStructure(type, params, jdbcEnvironment, sequenceName, initialValue, incrementSize);
        }
        return this.buildTableStructure(type, params, jdbcEnvironment, sequenceName, initialValue, incrementSize);
    }

    protected boolean isPhysicalSequence(JdbcEnvironment jdbcEnvironment, boolean forceTableUse) {
        return jdbcEnvironment.getDialect().getSequenceSupport().supportsSequences() && !forceTableUse;
    }

    protected DatabaseStructure buildSequenceStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, QualifiedName sequenceName, int initialValue, int incrementSize) {
        return new SequenceStructure(jdbcEnvironment, this.determineContributor(params), sequenceName, initialValue, incrementSize, type.getReturnedClass());
    }

    protected DatabaseStructure buildTableStructure(Type type, Properties params, JdbcEnvironment jdbcEnvironment, QualifiedName sequenceName, int initialValue, int incrementSize) {
        Identifier valueColumnName = this.determineValueColumnName(params, jdbcEnvironment);
        String contributor = this.determineContributor(params);
        return new TableStructure(jdbcEnvironment, contributor, sequenceName, valueColumnName, initialValue, incrementSize, type.getReturnedClass());
    }

    private String determineContributor(Properties params) {
        String contributor = params.getProperty("CONTRIBUTOR");
        return contributor == null ? "orm" : contributor;
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.optimizer.generate(this.databaseStructure.buildCallback(session));
    }

    @Override
    public Object generatorKey() {
        return this.databaseStructure.getName();
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlCreateStrings(dialect);
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlDropStrings(dialect);
    }

    @Override
    public boolean supportsBulkInsertionIdentifierGeneration() {
        return NoopOptimizer.class.isInstance(this.getOptimizer()) && this.getDatabaseStructure().isPhysicalSequence();
    }

    @Override
    public String determineBulkInsertionIdentifierGenerationSelectFragment(Dialect dialect) {
        return dialect.getSelectSequenceNextValString(this.getDatabaseStructure().getName());
    }

    @Override
    public void registerExportables(Database database) {
        this.databaseStructure.registerExportables(database);
    }

    private Long getSequenceIncrementValue(JdbcEnvironment jdbcEnvironment, String sequenceName) {
        return jdbcEnvironment.getExtractedDatabaseMetaData().getSequenceInformationList().stream().filter(sequenceInformation -> {
            Identifier catalog = sequenceInformation.getSequenceName().getCatalogName();
            Identifier schema = sequenceInformation.getSequenceName().getSchemaName();
            return !(!sequenceName.equalsIgnoreCase(sequenceInformation.getSequenceName().getSequenceName().getText()) || catalog != null && !catalog.equals(jdbcEnvironment.getCurrentCatalog()) || schema != null && !schema.equals(jdbcEnvironment.getCurrentSchema()));
        }).map(SequenceInformation::getIncrementValue).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

