/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.NaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.internal.SimpleQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.stat.spi.StatisticsImplementor;

public abstract class AbstractNaturalIdLoader<T>
implements NaturalIdLoader<T> {
    private final NaturalIdMapping naturalIdMapping;
    private final EntityMappingType entityDescriptor;

    public AbstractNaturalIdLoader(NaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        this.naturalIdMapping = naturalIdMapping;
        this.entityDescriptor = entityDescriptor;
    }

    protected EntityMappingType entityDescriptor() {
        return this.entityDescriptor;
    }

    protected NaturalIdMapping naturalIdMapping() {
        return this.naturalIdMapping;
    }

    @Override
    public Loadable getLoadable() {
        return this.entityDescriptor();
    }

    @Override
    public T load(Object naturalIdValue, NaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        return (T)this.selectByNaturalId(this.naturalIdMapping().normalizeInput(naturalIdValue, session), options, (tableGroup, creationState) -> this.entityDescriptor.createDomainResult(new NavigablePath(this.entityDescriptor().getRootPathName()), (TableGroup)tableGroup, null, (DomainResultCreationState)creationState), (fetchParent, querySpec, creationState) -> {
            ArrayList fetches = new ArrayList(this.naturalIdMapping.getNaturalIdAttributes().size());
            fetchParent.getReferencedMappingContainer().visitFetchables(fetchable -> {
                NavigablePath navigablePath = fetchParent.resolveNavigablePath((Fetchable)fetchable);
                Fetch fetch = fetchParent.generateFetchableFetch((Fetchable)fetchable, navigablePath, fetchable.getMappedFetchOptions().getTiming(), true, null, creationState);
                fetches.add(fetch);
            }, this.entityDescriptor);
            return fetches;
        }, statsEnabled -> statsEnabled != false ? System.nanoTime() : -1L, (result, startToken) -> {
            if (startToken > 0L) {
                session.getFactory().getStatistics().naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startToken);
            }
        }, session);
    }

    protected <L> L selectByNaturalId(Object bindValue, NaturalIdLoadOptions options, BiFunction<TableGroup, LoaderSqlAstCreationState, DomainResult<?>> domainResultProducer, LoaderSqlAstCreationState.FetchProcessor fetchProcessor, Function<Boolean, Long> statementStartHandler, BiConsumer<Object, Long> statementCompletionHandler, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        LockOptions lockOptions = options.getLockOptions() != null ? options.getLockOptions() : LockOptions.NONE;
        NavigablePath entityPath = new NavigablePath(this.entityDescriptor.getRootPathName());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), lockOptions, fetchProcessor, true, sessionFactory);
        TableGroup rootTableGroup = this.entityDescriptor.createRootTableGroup(true, entityPath, null, () -> rootQuerySpec::applyPredicate, sqlAstCreationState, sessionFactory);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        DomainResult<?> domainResult = domainResultProducer.apply(rootTableGroup, sqlAstCreationState);
        SelectStatement sqlSelect = new SelectStatement(rootQuerySpec, Collections.singletonList(domainResult));
        ArrayList jdbcParameters = new ArrayList(this.naturalIdMapping.getJdbcTypeCount());
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        this.applyNaturalIdRestriction(bindValue, rootTableGroup, rootQuerySpec::applyPredicate, (jdbcParameter, jdbcParameterBinding) -> {
            jdbcParameters.add(jdbcParameter);
            jdbcParamBindings.addBinding((JdbcParameter)jdbcParameter, (JdbcParameterBinding)jdbcParameterBinding);
        }, sqlAstCreationState, session);
        final SimpleQueryOptions queryOptions = new SimpleQueryOptions(lockOptions, false);
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlSelect).translate(jdbcParamBindings, queryOptions);
        StatisticsImplementor statistics = sessionFactory.getStatistics();
        Long startToken = statementStartHandler.apply(statistics.isStatisticsEnabled());
        List<Object> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }

            @Override
            public String getQueryIdentifier(String sql) {
                return sql;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                throw new UnsupportedOperationException("Follow-on locking not supported yet");
            }
        }, row -> row[0], ListResultsConsumer.UniqueSemantic.FILTER);
        if (results.size() > 1) {
            throw new HibernateException(String.format("Loading by natural-id returned more that one row : %s", this.entityDescriptor.getEntityName()));
        }
        Object result = results.isEmpty() ? null : results.get(0);
        statementCompletionHandler.accept(result, startToken);
        return (L)result;
    }

    protected abstract void applyNaturalIdRestriction(Object var1, TableGroup var2, Consumer<Predicate> var3, BiConsumer<JdbcParameter, JdbcParameterBinding> var4, LoaderSqlAstCreationState var5, SharedSessionContractImplementor var6);

    protected Expression resolveColumnReference(TableGroup rootTableGroup, SelectableMapping selectableMapping, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        TableReference tableReference = rootTableGroup.getTableReference(rootTableGroup.getNavigablePath(), selectableMapping.getContainingTableExpression());
        if (tableReference == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Unable to locate TableReference for `%s` : %s", selectableMapping.getContainingTableExpression(), rootTableGroup));
        }
        return sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping.getSelectionExpression(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getCustomWriteExpression(), selectableMapping.getJdbcMapping(), sessionFactory));
    }

    @Override
    public Object resolveNaturalIdToId(Object naturalIdValue, SharedSessionContractImplementor session) {
        return this.selectByNaturalId(this.naturalIdMapping().normalizeInput(naturalIdValue, session), NaturalIdLoadOptions.NONE, (tableGroup, creationState) -> this.entityDescriptor.getIdentifierMapping().createDomainResult(tableGroup.getNavigablePath().append("{id}"), (TableGroup)tableGroup, null, (DomainResultCreationState)creationState), (fetchParent, querySpec, creationState) -> {
            ArrayList fetches = new ArrayList();
            fetchParent.getReferencedMappingContainer().visitFetchables(fetchable -> {
                NavigablePath navigablePath = fetchParent.resolveNavigablePath((Fetchable)fetchable);
                Fetch fetch = fetchParent.generateFetchableFetch((Fetchable)fetchable, navigablePath, fetchable.getMappedFetchOptions().getTiming(), true, null, creationState);
                fetches.add(fetch);
            }, null);
            return fetches;
        }, statsEnabled -> statsEnabled != false ? System.nanoTime() : -1L, (result, startToken) -> {
            if (startToken > 0L) {
                session.getFactory().getStatistics().naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startToken);
            }
        }, session);
    }

    @Override
    public Object resolveIdToNaturalId(Object id, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect((Loadable)this.entityDescriptor(), Collections.singletonList(this.naturalIdMapping()), this.entityDescriptor().getIdentifierMapping(), null, 1, session.getLoadQueryInfluencers(), LockOptions.NONE, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParamBindings.registerParametersForEachJdbcValue(id, Clause.WHERE, this.entityDescriptor().getIdentifierMapping(), jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlSelect).translate(jdbcParamBindings, QueryOptions.NONE);
        List<Object> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public String getQueryIdentifier(String sql) {
                return sql;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                throw new UnsupportedOperationException("Follow-on locking not supported yet");
            }
        }, row -> {
            assert (row.length == 1);
            return row[0];
        }, ListResultsConsumer.UniqueSemantic.FILTER);
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new HibernateException(String.format("Resolving id to natural-id returned more that one row : %s #%s", this.entityDescriptor().getEntityName(), id));
        }
        return results.get(0);
    }
}

