/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.Loader;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class CollectionElementLoaderByIndex
implements Loader {
    private final PluralAttributeMapping attributeMapping;
    private final SelectStatement sqlAst;
    private final List<JdbcParameter> jdbcParameters;
    private final int baseIndex;
    private final int keyJdbcCount;

    public CollectionElementLoaderByIndex(PluralAttributeMapping attributeMapping, int baseIndex, LoadQueryInfluencers influencers, SessionFactoryImplementor sessionFactory) {
        this.attributeMapping = attributeMapping;
        this.baseIndex = baseIndex;
        ForeignKeyDescriptor keyDescriptor = attributeMapping.getKeyDescriptor();
        CollectionPart indexDescriptor = attributeMapping.getIndexDescriptor();
        ArrayList<ModelPart> restrictedParts = new ArrayList<ModelPart>();
        restrictedParts.add(keyDescriptor);
        if (indexDescriptor instanceof EntityCollectionPart) {
            EntityIdentifierMapping identifierMapping = ((EntityCollectionPart)indexDescriptor).getEntityMappingType().getIdentifierMapping();
            restrictedParts.add(identifierMapping);
            this.keyJdbcCount = keyDescriptor.getJdbcTypeCount() + identifierMapping.getJdbcTypeCount();
        } else {
            restrictedParts.add(indexDescriptor);
            this.keyJdbcCount = keyDescriptor.getJdbcTypeCount() + indexDescriptor.getJdbcTypeCount();
        }
        ArrayList<CollectionPart> partsToSelect = new ArrayList<CollectionPart>();
        partsToSelect.add(attributeMapping.getElementDescriptor());
        this.jdbcParameters = new ArrayList<JdbcParameter>(this.keyJdbcCount);
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)attributeMapping, partsToSelect, restrictedParts, null, 1, influencers, LockOptions.NONE, this.jdbcParameters::add, sessionFactory);
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.getAttributeMapping();
    }

    public PluralAttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    public SelectStatement getSqlAst() {
        return this.sqlAst;
    }

    public List<JdbcParameter> getJdbcParameters() {
        return this.jdbcParameters;
    }

    public Object load(Object key, Object index, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.keyJdbcCount);
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(key, Clause.WHERE, this.attributeMapping.getKeyDescriptor(), this.jdbcParameters, session);
        offset += jdbcParameterBindings.registerParametersForEachJdbcValue(this.incrementIndexByBase(index), Clause.WHERE, offset, this.attributeMapping.getIndexDescriptor(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, this.sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        List list = jdbcServices.getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public CollectionKey getCollectionKey() {
                return null;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public String getQueryIdentifier(String sql) {
                return sql;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        }, RowTransformerPassThruImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    protected Object incrementIndexByBase(Object index) {
        if (this.baseIndex != 0) {
            index = (Integer)index + this.baseIndex;
        }
        return index;
    }
}

