/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.BagSemantics;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.FilterHelper;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.NonAggregatedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.RootTableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.collection.internal.CollectionDomainResult;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.StandardEntityGraphTraversalStateImpl;
import org.jboss.logging.Logger;

public class LoaderSelectBuilder {
    private static final Logger log = Logger.getLogger(LoaderSelectBuilder.class);
    private final SqlAstCreationContext creationContext;
    private final Loadable loadable;
    private final List<? extends ModelPart> partsToSelect;
    private final List<ModelPart> restrictedParts;
    private final DomainResult cachedDomainResult;
    private final int numberOfKeysToLoad;
    private final boolean forceIdentifierSelection;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final LockOptions lockOptions;
    private final Consumer<JdbcParameter> jdbcParameterConsumer;
    private final EntityGraphTraversalState entityGraphTraversalState;
    private int fetchDepth;
    private Map<OrderByFragment, TableGroup> orderByFragments;
    private boolean hasCollectionJoinFetches;
    private String currentBagRole;

    public static SelectStatement createSelectByUniqueKey(Loadable loadable, List<? extends ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder(sessionFactory, loadable, partsToSelect, Collections.singletonList(restrictedPart), cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, LoaderSelectBuilder.determineGraphTraversalState(loadQueryInfluencers), true, jdbcParameterConsumer);
        return process.generateSelect();
    }

    public static SelectStatement createSelect(Loadable loadable, List<? extends ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder((SqlAstCreationContext)sessionFactory, loadable, partsToSelect, restrictedPart, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.generateSelect();
    }

    public static SelectStatement createSelect(Loadable loadable, List<? extends ModelPart> partsToSelect, List<ModelPart> restrictedParts, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder((SqlAstCreationContext)sessionFactory, loadable, partsToSelect, restrictedParts, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.generateSelect();
    }

    public static SelectStatement createSubSelectFetchSelect(PluralAttributeMapping attributeMapping, SubselectFetch subselect, DomainResult cachedDomainResult, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder((SqlAstCreationContext)sessionFactory, (Loadable)attributeMapping, null, attributeMapping.getKeyDescriptor(), cachedDomainResult, -1, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.generateSelect(subselect);
    }

    private LoaderSelectBuilder(SqlAstCreationContext creationContext, Loadable loadable, List<? extends ModelPart> partsToSelect, List<ModelPart> restrictedParts, DomainResult cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, EntityGraphTraversalState entityGraphTraversalState, boolean forceIdentifierSelection, Consumer<JdbcParameter> jdbcParameterConsumer) {
        this.creationContext = creationContext;
        this.loadable = loadable;
        this.partsToSelect = partsToSelect;
        this.restrictedParts = restrictedParts;
        this.cachedDomainResult = cachedDomainResult;
        this.numberOfKeysToLoad = numberOfKeysToLoad;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.lockOptions = lockOptions;
        this.entityGraphTraversalState = entityGraphTraversalState;
        this.forceIdentifierSelection = forceIdentifierSelection;
        this.jdbcParameterConsumer = jdbcParameterConsumer;
    }

    private LoaderSelectBuilder(SqlAstCreationContext creationContext, Loadable loadable, List<? extends ModelPart> partsToSelect, List<ModelPart> restrictedParts, DomainResult cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer) {
        this(creationContext, loadable, partsToSelect, restrictedParts, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions != null ? lockOptions : LockOptions.NONE, LoaderSelectBuilder.determineGraphTraversalState(loadQueryInfluencers), LoaderSelectBuilder.determineWhetherToForceIdSelection(numberOfKeysToLoad, restrictedParts), jdbcParameterConsumer);
    }

    private LoaderSelectBuilder(SqlAstCreationContext creationContext, Loadable loadable, List<? extends ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer) {
        this(creationContext, loadable, partsToSelect, Arrays.asList(restrictedPart), cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
    }

    private static boolean determineWhetherToForceIdSelection(int numberOfKeysToLoad, List<ModelPart> restrictedParts) {
        ModelPart restrictedPart;
        if (numberOfKeysToLoad > 1) {
            return true;
        }
        if (restrictedParts.size() == 1 && Objects.equals((restrictedPart = restrictedParts.get(0)).getPartName(), "{natural-id}")) {
            return true;
        }
        for (ModelPart restrictedPart2 : restrictedParts) {
            if (!(restrictedPart2 instanceof ForeignKeyDescriptor) && !(restrictedPart2 instanceof NonAggregatedIdentifierMappingImpl)) continue;
            return true;
        }
        return false;
    }

    private static EntityGraphTraversalState determineGraphTraversalState(LoadQueryInfluencers loadQueryInfluencers) {
        EffectiveEntityGraph effectiveEntityGraph;
        if (loadQueryInfluencers != null && (effectiveEntityGraph = loadQueryInfluencers.getEffectiveEntityGraph()) != null) {
            GraphSemantic graphSemantic = effectiveEntityGraph.getSemantic();
            RootGraphImplementor<?> rootGraphImplementor = effectiveEntityGraph.getGraph();
            if (graphSemantic != null && rootGraphImplementor != null) {
                return new StandardEntityGraphTraversalStateImpl(graphSemantic, rootGraphImplementor);
            }
        }
        return null;
    }

    private SelectStatement generateSelect() {
        List<DomainResult<?>> domainResults;
        PluralAttributeMapping pluralAttributeMapping;
        if (this.loadable instanceof PluralAttributeMapping && (pluralAttributeMapping = (PluralAttributeMapping)this.loadable).getMappedType().getCollectionSemantics() instanceof BagSemantics) {
            this.currentBagRole = pluralAttributeMapping.getNavigableRole().getNavigableName();
        }
        NavigablePath rootNavigablePath = new NavigablePath(this.loadable.getRootPathName());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), this.lockOptions, this::visitFetches, this.forceIdentifierSelection, this.creationContext);
        TableGroup rootTableGroup = this.loadable.createRootTableGroup(true, rootNavigablePath, null, () -> rootQuerySpec::applyPredicate, sqlAstCreationState, this.creationContext);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(rootNavigablePath, rootTableGroup);
        if (this.partsToSelect != null && !this.partsToSelect.isEmpty()) {
            domainResults = new ArrayList<DomainResult>(this.partsToSelect.size());
            for (ModelPart modelPart : this.partsToSelect) {
                TableGroup tableGroup2;
                TableGroup tableGroup3;
                NavigablePath navigablePath = rootNavigablePath.append(modelPart.getPartName());
                if (modelPart instanceof RootTableGroupProducer) {
                    tableGroup3 = ((RootTableGroupProducer)modelPart).createRootTableGroup(true, navigablePath, null, () -> rootQuerySpec::applyPredicate, sqlAstCreationState, this.creationContext);
                    rootQuerySpec.getFromClause().addRoot(tableGroup3);
                    sqlAstCreationState.getFromClauseAccess().registerTableGroup(navigablePath, tableGroup3);
                } else if (modelPart instanceof ToOneAttributeMapping) {
                    ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)modelPart;
                    if (toOneAttributeMapping.getSideNature() == ForeignKeyDescriptor.Nature.TARGET) {
                        TableGroupJoin tableGroupJoin = toOneAttributeMapping.createTableGroupJoin(navigablePath, rootTableGroup, null, SqlAstJoinType.LEFT, true, sqlAstCreationState);
                        tableGroup3 = tableGroupJoin.getJoinedGroup();
                        sqlAstCreationState.getFromClauseAccess().registerTableGroup(navigablePath, tableGroup3);
                    } else {
                        tableGroup3 = rootTableGroup;
                    }
                } else {
                    tableGroup2 = rootTableGroup;
                }
                domainResults.add(modelPart.createDomainResult(navigablePath, tableGroup2, null, sqlAstCreationState));
            }
        } else {
            DomainResult domainResult = this.cachedDomainResult != null ? this.cachedDomainResult : this.loadable.createDomainResult(rootNavigablePath, rootTableGroup, null, sqlAstCreationState);
            domainResults = Collections.singletonList(domainResult);
        }
        for (ModelPart modelPart : this.restrictedParts) {
            int numberOfRestrictionColumns = modelPart.getJdbcTypeCount();
            this.applyRestriction(rootQuerySpec, rootNavigablePath, rootTableGroup, modelPart, numberOfRestrictionColumns, this.jdbcParameterConsumer, sqlAstCreationState);
        }
        if (this.loadable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping2 = (PluralAttributeMapping)this.loadable;
            this.applyFiltering(rootQuerySpec, rootTableGroup, pluralAttributeMapping2);
            this.applyOrdering(rootTableGroup, pluralAttributeMapping2);
        } else if (this.loadable instanceof Joinable) {
            this.applyFiltering(rootQuerySpec, rootTableGroup, (Joinable)((Object)this.loadable));
        }
        if (this.orderByFragments != null) {
            this.orderByFragments.forEach((orderByFragment, tableGroup) -> orderByFragment.apply(rootQuerySpec, (TableGroup)tableGroup, sqlAstCreationState));
        }
        return new SelectStatement(rootQuerySpec, domainResults);
    }

    private void applyRestriction(QuerySpec rootQuerySpec, NavigablePath rootNavigablePath, TableGroup rootTableGroup, ModelPart modelPart, int numberColumns, Consumer<JdbcParameter> jdbcParameterConsumer, LoaderSqlAstCreationState sqlAstCreationState) {
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        NavigablePath navigablePath = rootNavigablePath.append(modelPart.getNavigableRole().getNavigableName());
        if (numberColumns == 1) {
            modelPart.forEachSelectable((columnIndex, selection) -> {
                TableReference tableReference = rootTableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
                ColumnReference columnRef = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), p -> new ColumnReference(tableReference, selection, this.creationContext.getSessionFactory()));
                if (this.numberOfKeysToLoad == 1) {
                    JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(selection.getJdbcMapping());
                    jdbcParameterConsumer.accept(jdbcParameter);
                    rootQuerySpec.applyPredicate(new ComparisonPredicate(columnRef, ComparisonOperator.EQUAL, jdbcParameter));
                } else {
                    InListPredicate predicate = new InListPredicate(columnRef);
                    for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                        for (int j = 0; j < numberColumns; ++j) {
                            JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(columnRef.getJdbcMapping());
                            jdbcParameterConsumer.accept(jdbcParameter);
                            predicate.addExpression(jdbcParameter);
                        }
                    }
                    rootQuerySpec.applyPredicate(predicate);
                }
            });
        } else {
            ArrayList columnReferences = new ArrayList(numberColumns);
            modelPart.forEachSelectable((columnIndex, selection) -> {
                TableReference tableReference = rootTableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
                columnReferences.add((ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), p -> new ColumnReference(tableReference, selection, this.creationContext.getSessionFactory())));
            });
            SqlTuple tuple = new SqlTuple(columnReferences, modelPart);
            InListPredicate predicate = new InListPredicate(tuple);
            for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                ArrayList<JdbcParameterImpl> tupleParams = new ArrayList<JdbcParameterImpl>(numberColumns);
                for (int j = 0; j < numberColumns; ++j) {
                    ColumnReference columnReference = (ColumnReference)columnReferences.get(j);
                    JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(columnReference.getJdbcMapping());
                    jdbcParameterConsumer.accept(jdbcParameter);
                    tupleParams.add(jdbcParameter);
                }
                SqlTuple paramTuple = new SqlTuple(tupleParams, modelPart);
                predicate.addExpression(paramTuple);
            }
            rootQuerySpec.applyPredicate(predicate);
        }
    }

    private void applyFiltering(QuerySpec querySpec, TableGroup tableGroup, PluralAttributeMapping pluralAttributeMapping) {
        Joinable joinable = pluralAttributeMapping.getCollectionDescriptor().getCollectionType().getAssociatedJoinable(this.creationContext.getSessionFactory());
        FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.loadQueryInfluencers, joinable, tableGroup);
        if (filterPredicate != null) {
            querySpec.applyPredicate(filterPredicate);
        }
        if (pluralAttributeMapping.getCollectionDescriptor().isManyToMany()) {
            assert (joinable instanceof CollectionPersister);
            FilterPredicate manyToManyFilterPredicate = FilterHelper.createManyToManyFilterPredicate(this.loadQueryInfluencers, (CollectionPersister)((Object)joinable), tableGroup);
            if (manyToManyFilterPredicate != null) {
                assert (tableGroup.getTableReferenceJoins().size() == 1);
                tableGroup.getTableReferenceJoins().get(0).applyPredicate(manyToManyFilterPredicate);
            }
        }
    }

    private void applyFiltering(QuerySpec querySpec, TableGroup tableGroup, Joinable joinable) {
        FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.loadQueryInfluencers, joinable, tableGroup);
        if (filterPredicate != null) {
            querySpec.applyPredicate(filterPredicate);
        }
    }

    private void applyOrdering(TableGroup tableGroup, PluralAttributeMapping pluralAttributeMapping) {
        if (pluralAttributeMapping.getOrderByFragment() != null) {
            this.applyOrdering(tableGroup, pluralAttributeMapping.getOrderByFragment());
        }
        if (pluralAttributeMapping.getManyToManyOrderByFragment() != null) {
            this.applyOrdering(tableGroup, pluralAttributeMapping.getManyToManyOrderByFragment());
        }
    }

    private void applyOrdering(TableGroup tableGroup, OrderByFragment orderByFragment) {
        if (this.orderByFragments == null) {
            this.orderByFragments = new LinkedHashMap<OrderByFragment, TableGroup>();
        }
        this.orderByFragments.put(orderByFragment, tableGroup);
    }

    private List<Fetch> visitFetches(FetchParent fetchParent, QuerySpec querySpec, LoaderSqlAstCreationState creationState) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting visitation of FetchParent's Fetchables : %s", (Object)fetchParent.getNavigablePath());
        }
        ArrayList<Fetch> fetches = new ArrayList<Fetch>();
        BiConsumer<Fetchable, Boolean> processor = this.createFetchableBiConsumer(fetchParent, querySpec, creationState, fetches);
        FetchableContainer referencedMappingContainer = fetchParent.getReferencedMappingContainer();
        if (fetchParent.getNavigablePath().getParent() != null) {
            referencedMappingContainer.visitKeyFetchables(fetchable -> processor.accept((Fetchable)fetchable, true), null);
        }
        referencedMappingContainer.visitFetchables(fetchable -> processor.accept((Fetchable)fetchable, false), null);
        return fetches;
    }

    private BiConsumer<Fetchable, Boolean> createFetchableBiConsumer(FetchParent fetchParent, QuerySpec querySpec, LoaderSqlAstCreationState creationState, List<Fetch> fetches) {
        return (fetchable, isKeyFetchable) -> {
            NavigablePath fetchablePath;
            if (isKeyFetchable.booleanValue()) {
                EntityIdentifierMapping identifierMapping;
                if (fetchParent instanceof BiDirectionalFetch) {
                    BiDirectionalFetch parentAsBiDirectionalFetch = (BiDirectionalFetch)((Object)fetchParent);
                    Fetchable biDirectionalFetchedMapping = parentAsBiDirectionalFetch.getFetchedMapping();
                    identifierMapping = biDirectionalFetchedMapping instanceof EntityValuedFetchable ? ((EntityValuedFetchable)biDirectionalFetchedMapping).getEntityMappingType().getIdentifierMapping() : null;
                } else {
                    FetchableContainer fetchableContainer = fetchParent.getReferencedMappingContainer();
                    if (fetchableContainer instanceof EntityValuedModelPart) {
                        EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)fetchableContainer;
                        identifierMapping = entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
                    } else {
                        identifierMapping = null;
                    }
                }
                fetchablePath = identifierMapping != null ? new EntityIdentifierNavigablePath(fetchParent.getNavigablePath(), ResultsHelper.attributeName(identifierMapping)) : fetchParent.resolveNavigablePath((Fetchable)fetchable);
            } else {
                fetchablePath = fetchParent.resolveNavigablePath((Fetchable)fetchable);
            }
            FetchTiming fetchTiming = fetchable.getMappedFetchOptions().getTiming();
            boolean joined = fetchable.getMappedFetchOptions().getStyle() == FetchStyle.JOIN;
            EntityGraphTraversalState.TraversalResult traversalResult = null;
            if (!(fetchable instanceof CollectionPart)) {
                if (this.entityGraphTraversalState != null) {
                    traversalResult = this.entityGraphTraversalState.traverse(fetchParent, (Fetchable)fetchable, (boolean)isKeyFetchable);
                    fetchTiming = traversalResult.getFetchTiming();
                    joined = traversalResult.isJoined();
                } else if (this.loadQueryInfluencers.hasEnabledFetchProfiles()) {
                    if (fetchTiming != FetchTiming.IMMEDIATE || fetchable.incrementFetchDepth()) {
                        String fetchableRole = fetchable.getNavigableRole().getFullPath();
                        for (String enabledFetchProfileName : this.loadQueryInfluencers.getEnabledFetchProfileNames()) {
                            FetchProfile enabledFetchProfile = this.creationContext.getSessionFactory().getFetchProfile(enabledFetchProfileName);
                            org.hibernate.engine.profile.Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                            if (profileFetch == null) continue;
                            fetchTiming = FetchTiming.IMMEDIATE;
                            joined = joined || profileFetch.getStyle() == Fetch.Style.JOIN;
                        }
                    }
                } else if (this.loadQueryInfluencers.getEnabledCascadingFetchProfile() != null) {
                    CascadeStyle cascadeStyle = ((AttributeMapping)fetchable).getAttributeMetadataAccess().resolveAttributeMetadata(fetchable.findContainingEntityMapping()).getCascadeStyle();
                    CascadingAction cascadingAction = this.loadQueryInfluencers.getEnabledCascadingFetchProfile().getCascadingAction();
                    if (cascadeStyle == null || cascadeStyle.doCascade(cascadingAction)) {
                        fetchTiming = FetchTiming.IMMEDIATE;
                        joined = !this.hasCollectionJoinFetches;
                    }
                }
            }
            String previousBagRole = this.currentBagRole;
            String bagRole = fetchable instanceof PluralAttributeMapping && ((PluralAttributeMapping)fetchable).getMappedType().getCollectionSemantics() instanceof BagSemantics ? fetchable.getNavigableRole().getNavigableName() : null;
            if (joined && previousBagRole != null && bagRole != null) {
                joined = false;
            }
            boolean changeFetchDepth = !(fetchable instanceof BasicValuedModelPart) && !(fetchable instanceof EmbeddedAttributeMapping) && !(fetchable instanceof CollectionPart);
            try {
                Fetch fetch;
                Fetch biDirectionalFetch;
                if (changeFetchDepth) {
                    ++this.fetchDepth;
                }
                if (!creationState.isResolvingCircularFetch() && (biDirectionalFetch = fetchable.resolveCircularFetch(fetchablePath, fetchParent, fetchTiming, creationState)) != null) {
                    fetches.add(biDirectionalFetch);
                    return;
                }
                Integer maximumFetchDepth = this.creationContext.getMaximumFetchDepth();
                if (maximumFetchDepth != null) {
                    if (this.fetchDepth == maximumFetchDepth + 1) {
                        joined = false;
                    } else if (this.fetchDepth > maximumFetchDepth + 1 && !(fetchable instanceof BasicValuedModelPart) && !(fetchable instanceof EmbeddedAttributeMapping)) {
                        return;
                    }
                }
                if (joined) {
                    if (bagRole != null) {
                        this.currentBagRole = bagRole;
                    }
                } else {
                    this.currentBagRole = null;
                }
                if ((fetch = fetchParent.generateFetchableFetch((Fetchable)fetchable, fetchablePath, fetchTiming, joined, null, creationState)).getTiming() == FetchTiming.IMMEDIATE && fetchable instanceof PluralAttributeMapping) {
                    PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                    if (joined) {
                        this.hasCollectionJoinFetches = true;
                        TableGroup joinTableGroup = creationState.getFromClauseAccess().getTableGroup(fetchablePath);
                        this.applyFiltering(querySpec, joinTableGroup, pluralAttributeMapping);
                        this.applyOrdering(querySpec, fetchablePath, pluralAttributeMapping, creationState);
                    }
                }
                fetches.add(fetch);
            }
            finally {
                if (changeFetchDepth) {
                    --this.fetchDepth;
                }
                if (!joined) {
                    this.currentBagRole = previousBagRole;
                }
                if (this.entityGraphTraversalState != null && traversalResult != null) {
                    this.entityGraphTraversalState.backtrack(traversalResult.getPreviousContext());
                }
            }
        };
    }

    private void applyOrdering(QuerySpec ast, NavigablePath navigablePath, PluralAttributeMapping pluralAttributeMapping, LoaderSqlAstCreationState sqlAstCreationState) {
        assert (pluralAttributeMapping.getAttributeName().equals(navigablePath.getLocalName()));
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(navigablePath);
        assert (tableGroup != null);
        this.applyOrdering(tableGroup, pluralAttributeMapping);
    }

    private SelectStatement generateSelect(SubselectFetch subselect) {
        assert (this.loadable instanceof PluralAttributeMapping);
        PluralAttributeMapping attributeMapping = (PluralAttributeMapping)this.loadable;
        QuerySpec rootQuerySpec = new QuerySpec(true);
        NavigablePath rootNavigablePath = new NavigablePath(this.loadable.getRootPathName());
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), this.lockOptions, this::visitFetches, this.numberOfKeysToLoad > 1, this.creationContext);
        TableGroup rootTableGroup = this.loadable.createRootTableGroup(true, rootNavigablePath, null, () -> rootQuerySpec::applyPredicate, sqlAstCreationState, this.creationContext);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(rootNavigablePath, rootTableGroup);
        this.applySubSelectRestriction(rootQuerySpec, rootNavigablePath, rootTableGroup, subselect, sqlAstCreationState);
        this.applyFiltering(rootQuerySpec, rootTableGroup, attributeMapping);
        this.applyOrdering(rootTableGroup, attributeMapping);
        subselect.getLoadingJdbcParameters().forEach(this.jdbcParameterConsumer);
        return new SelectStatement(rootQuerySpec, Collections.singletonList(new CollectionDomainResult(rootNavigablePath, attributeMapping, null, rootTableGroup, sqlAstCreationState)));
    }

    private void applySubSelectRestriction(QuerySpec querySpec, NavigablePath rootNavigablePath, TableGroup rootTableGroup, SubselectFetch subselect, LoaderSqlAstCreationState sqlAstCreationState) {
        Expression fkExpression;
        SqlAstCreationContext sqlAstCreationContext = sqlAstCreationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = sqlAstCreationContext.getSessionFactory();
        assert (this.loadable instanceof PluralAttributeMapping);
        PluralAttributeMapping attributeMapping = (PluralAttributeMapping)this.loadable;
        ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
        NavigablePath navigablePath = rootNavigablePath.append(attributeMapping.getAttributeName());
        int jdbcTypeCount = fkDescriptor.getJdbcTypeCount();
        if (jdbcTypeCount == 1) {
            assert (fkDescriptor instanceof SimpleForeignKeyDescriptor);
            SimpleForeignKeyDescriptor simpleFkDescriptor = (SimpleForeignKeyDescriptor)fkDescriptor;
            fkExpression = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(simpleFkDescriptor.getContainingTableExpression(), simpleFkDescriptor.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(rootTableGroup.resolveTableReference(navigablePath, simpleFkDescriptor.getContainingTableExpression()), simpleFkDescriptor.getSelectionExpression(), false, null, null, simpleFkDescriptor.getJdbcMapping(), this.creationContext.getSessionFactory()));
        } else {
            ArrayList columnReferences = new ArrayList(jdbcTypeCount);
            fkDescriptor.forEachSelectable((columnIndex, selection) -> columnReferences.add((ColumnReference)sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(selection.getContainingTableExpression(), selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(rootTableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression()), selection, this.creationContext.getSessionFactory()))));
            fkExpression = new SqlTuple(columnReferences, fkDescriptor);
        }
        querySpec.applyPredicate(new InSubQueryPredicate(fkExpression, this.generateSubSelect(attributeMapping, rootTableGroup, subselect, jdbcTypeCount, sqlAstCreationState, sessionFactory), false));
    }

    private QueryPart generateSubSelect(PluralAttributeMapping attributeMapping, TableGroup rootTableGroup, SubselectFetch subselect, int jdbcTypeCount, LoaderSqlAstCreationState creationState, SessionFactoryImplementor sessionFactory) {
        ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
        QuerySpec subQuery = new QuerySpec(false);
        QuerySpec loadingSqlAst = subselect.getLoadingSqlAst();
        TableGroup ownerTableGroup = subselect.getOwnerTableGroup();
        loadingSqlAst.getFromClause().visitRoots(subQuery.getFromClause()::addRoot);
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        NavigablePath navigablePath = ownerTableGroup.getNavigablePath().append(attributeMapping.getAttributeName());
        fkDescriptor.visitTargetSelectables((valuesPosition, selection) -> {
            TableReference tableReference = ownerTableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
            Expression expression = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference, selection, sessionFactory));
            subQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(valuesPosition + 1, valuesPosition, expression));
        });
        subQuery.applyPredicate(loadingSqlAst.getWhereClauseRestrictions());
        return subQuery;
    }
}

