/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.HashSet;
import java.util.List;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class LoadingEntityCollector {
    private final SubselectFetch subselectFetch;
    private final BatchFetchQueue batchFetchQueue;

    LoadingEntityCollector(EntityValuedModelPart loadingEntityDescriptor, QuerySpec loadingSqlAst, List<JdbcParameter> jdbcParameters, JdbcParameterBindings jdbcParameterBindings, BatchFetchQueue batchFetchQueue) {
        this.batchFetchQueue = batchFetchQueue;
        this.subselectFetch = new SubselectFetch(loadingEntityDescriptor, loadingSqlAst, loadingSqlAst.getFromClause().getRoots().get(0), jdbcParameters, jdbcParameterBindings, new HashSet<EntityKey>());
    }

    public void collectLoadingEntityKey(EntityKey entityKey) {
        this.subselectFetch.getResultingEntityKeys().add(entityKey);
        this.batchFetchQueue.addSubselect(entityKey, this.subselectFetch);
    }
}

