/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.MultiNaturalIdLoadingBatcher;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.sql.results.LoadingLogger;

public class MultiNaturalIdLoaderStandard<E>
implements MultiNaturalIdLoader<E> {
    private final EntityMappingType entityDescriptor;

    public MultiNaturalIdLoaderStandard(EntityMappingType entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
    }

    @Override
    public <K> List<E> multiLoad(K[] naturalIds, MultiNaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        if (naturalIds == null) {
            throw new IllegalArgumentException("`naturalIds` is null");
        }
        if (naturalIds.length == 0) {
            return Collections.emptyList();
        }
        if (LoadingLogger.LOGGER.isTraceEnabled()) {
            LoadingLogger.LOGGER.tracef("Starting multi natural-id loading for `%s`", (Object)this.entityDescriptor.getEntityName());
        }
        SessionFactoryImplementor sessionFactory = session.getFactory();
        int maxBatchSize = options.getBatchSize() != null && options.getBatchSize() > 0 ? options.getBatchSize().intValue() : session.getJdbcServices().getJdbcEnvironment().getDialect().getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.entityDescriptor.getNaturalIdMapping().getJdbcTypeCount(), naturalIds.length);
        int batchSize = Math.min(maxBatchSize, naturalIds.length);
        LockOptions lockOptions = options.getLockOptions() == null ? new LockOptions(LockMode.NONE) : options.getLockOptions();
        MultiNaturalIdLoadingBatcher batcher = new MultiNaturalIdLoadingBatcher(this.entityDescriptor, this.entityDescriptor.getNaturalIdMapping(), batchSize, (naturalId, session1) -> this.entityDescriptor.getNaturalIdMapping().normalizeInput(naturalId, session), session.getLoadQueryInfluencers(), lockOptions, sessionFactory);
        List results = batcher.multiLoad(naturalIds, options, session);
        if (options.isOrderReturnEnabled()) {
            throw new NotYetImplementedFor6Exception(this.getClass());
        }
        return results;
    }
}

