/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EntityInstantiatorDynamicMap;
import org.hibernate.metamodel.spi.EntityInstantiator;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.map.MapProxyFactory;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EntityRepresentationStrategyMap
implements EntityRepresentationStrategy {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityRepresentationStrategyMap.class);
    private final JavaTypeDescriptor<Map> mapJtd;
    private final ProxyFactory proxyFactory;
    private final EntityInstantiatorDynamicMap instantiator;
    private final Map<String, PropertyAccess> propertyAccessMap = new ConcurrentHashMap<String, PropertyAccess>();

    public EntityRepresentationStrategyMap(PersistentClass bootType, RuntimeModelCreationContext creationContext) {
        this.mapJtd = creationContext.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Map.class));
        this.proxyFactory = EntityRepresentationStrategyMap.createProxyFactory(bootType);
        this.instantiator = new EntityInstantiatorDynamicMap(bootType);
        Iterator<Property> itr = bootType.getPropertyClosureIterator();
        int i = 0;
        while (itr.hasNext()) {
            Property property = itr.next();
            PropertyAccess propertyAccess = PropertyAccessStrategyMapImpl.INSTANCE.buildPropertyAccess(null, property.getName());
            this.propertyAccessMap.put(property.getName(), propertyAccess);
            ++i;
        }
        EntityRepresentationStrategyMap.createProxyFactory(bootType);
    }

    private static ProxyFactory createProxyFactory(PersistentClass bootType) {
        try {
            MapProxyFactory proxyFactory = new MapProxyFactory();
            proxyFactory.postInstantiate(bootType.getEntityName(), null, null, null, null, null);
            return proxyFactory;
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(bootType.getEntityName(), he);
            return null;
        }
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.MAP;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return null;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        return PropertyAccessStrategyMapImpl.INSTANCE.buildPropertyAccess(null, bootAttributeDescriptor.getName());
    }

    @Override
    public EntityInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @Override
    public JavaTypeDescriptor<?> getMappedJavaTypeDescriptor() {
        return this.mapJtd;
    }

    @Override
    public JavaTypeDescriptor<?> getProxyJavaTypeDescriptor() {
        return null;
    }

    @Override
    public void visitEntityNameResolvers(Consumer<EntityNameResolver> consumer) {
        consumer.accept(EntityInstantiatorDynamicMap.ENTITY_NAME_RESOLVER);
    }
}

