/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyMap;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyPojo;
import org.hibernate.metamodel.internal.EntityRepresentationStrategyMap;
import org.hibernate.metamodel.internal.EntityRepresentationStrategyPojoStandard;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.ManagedTypeRepresentationResolver;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;

public class ManagedTypeRepresentationResolverStandard
implements ManagedTypeRepresentationResolver {
    public static final ManagedTypeRepresentationResolverStandard INSTANCE = new ManagedTypeRepresentationResolverStandard();

    @Override
    public EntityRepresentationStrategy resolveStrategy(PersistentClass bootDescriptor, EntityPersister runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        RepresentationMode representation = null;
        if (representation == null) {
            representation = bootDescriptor.getMappedClass() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        }
        if (representation == RepresentationMode.MAP) {
            return new EntityRepresentationStrategyMap(bootDescriptor, creationContext);
        }
        return new EntityRepresentationStrategyPojoStandard(bootDescriptor, runtimeDescriptor, creationContext);
    }

    @Override
    public EmbeddableRepresentationStrategy resolveStrategy(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        RepresentationMode representation = null;
        if (representation == null) {
            representation = bootDescriptor.getComponentClassName() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        }
        if (representation == RepresentationMode.MAP) {
            return new EmbeddableRepresentationStrategyMap(bootDescriptor, creationContext);
        }
        return new EmbeddableRepresentationStrategyPojo(bootDescriptor, creationContext);
    }
}

