/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.CompoundNaturalIdLoader;
import org.hibernate.loader.ast.internal.MultiNaturalIdLoaderStandard;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AttributeMetadataAccess;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractNaturalIdMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class CompoundNaturalIdMapping
extends AbstractNaturalIdMapping
implements MappingType,
FetchableContainer {
    private final List<SingularAttributeMapping> attributes;
    private final JavaTypeDescriptor<?> jtd;
    private List<JdbcMapping> jdbcMappings;

    public CompoundNaturalIdMapping(EntityMappingType declaringType, List<SingularAttributeMapping> attributes, MappingModelCreationProcess creationProcess) {
        super(declaringType, CompoundNaturalIdMapping.isMutable(declaringType, attributes, creationProcess));
        this.attributes = attributes;
        this.jtd = creationProcess.getCreationContext().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Object[].class));
        creationProcess.registerInitializationCallback("Determine compound natural-id JDBC mappings ( " + declaringType.getEntityName() + ")", () -> {
            ArrayList<JdbcMapping> jdbcMappings = new ArrayList<JdbcMapping>();
            attributes.forEach(attribute -> attribute.forEachJdbcType((index, jdbcMapping) -> jdbcMappings.add((JdbcMapping)jdbcMapping)));
            this.jdbcMappings = jdbcMappings;
            return true;
        });
    }

    private static boolean isMutable(EntityMappingType entityDescriptor, List<SingularAttributeMapping> attributes, MappingModelCreationProcess creationProcess) {
        for (int i = 0; i < attributes.size(); ++i) {
            SingularAttributeMapping attributeMapping = attributes.get(i);
            AttributeMetadataAccess metadataAccess = attributeMapping.getAttributeMetadataAccess();
            if (metadataAccess.resolveAttributeMetadata(entityDescriptor).isUpdatable()) continue;
            return false;
        }
        return true;
    }

    public Object[] extractNaturalIdFromEntityState(Object[] state, SharedSessionContractImplementor session) {
        if (state == null) {
            return null;
        }
        if (state.length == this.attributes.size()) {
            return state;
        }
        Object[] values = new Object[this.attributes.size()];
        for (int i = 0; i <= this.attributes.size() - 1; ++i) {
            SingularAttributeMapping attributeMapping = this.attributes.get(i);
            values[i] = state[attributeMapping.getStateArrayPosition()];
        }
        return values;
    }

    public Object[] extractNaturalIdFromEntity(Object entity, SharedSessionContractImplementor session) {
        Object[] values = new Object[this.attributes.size()];
        for (int i = 0; i < this.attributes.size(); ++i) {
            values[i] = this.attributes.get(i).getPropertyAccess().getGetter().get(entity);
        }
        return values;
    }

    public Object[] normalizeInput(Object incoming, SharedSessionContractImplementor session) {
        if (incoming instanceof Object[]) {
            return (Object[])incoming;
        }
        if (incoming instanceof Map) {
            Map valueMap = (Map)incoming;
            List<SingularAttributeMapping> attributes = this.getNaturalIdAttributes();
            Object[] values = new Object[attributes.size()];
            for (int i = 0; i < attributes.size(); ++i) {
                values[i] = valueMap.get(attributes.get(i).getAttributeName());
            }
            return values;
        }
        throw new UnsupportedOperationException("Do not know how to normalize compound natural-id value : " + incoming);
    }

    @Override
    public void validateInternalForm(Object naturalIdValue, SharedSessionContractImplementor session) {
        if (naturalIdValue == null) {
            return;
        }
        if (naturalIdValue instanceof Object[]) {
            Object[] values = (Object[])naturalIdValue;
            if (values.length != this.attributes.size()) {
                throw new IllegalArgumentException("Natural-id value [" + naturalIdValue + "] did not contain the expected number of elements [" + this.attributes.size() + "]");
            }
            return;
        }
        throw new IllegalArgumentException("Natural-id value [" + naturalIdValue + "] was not an array as expected");
    }

    @Override
    public int calculateHashCode(Object value, SharedSessionContractImplementor session) {
        return 0;
    }

    @Override
    public void verifyFlushState(Object id, Object[] currentState, Object[] loadedState, SharedSessionContractImplementor session) {
        if (this.isMutable()) {
            return;
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityPersister persister = this.getDeclaringType().getEntityPersister();
        Object[] naturalId = this.extractNaturalIdFromEntityState(currentState, session);
        Object snapshot = loadedState == null ? persistenceContext.getNaturalIdSnapshot(id, persister) : persister.getNaturalIdMapping().extractNaturalIdFromEntityState(loadedState, session);
        Object[] previousNaturalId = (Object[])snapshot;
        assert (naturalId.length == this.getNaturalIdAttributes().size());
        assert (previousNaturalId.length == naturalId.length);
        for (int i = 0; i < this.getNaturalIdAttributes().size(); ++i) {
            Object previousValue;
            Object currentValue;
            SingularAttributeMapping attributeMapping = this.getNaturalIdAttributes().get(i);
            boolean updatable = attributeMapping.getAttributeMetadataAccess().resolveAttributeMetadata(persister).isUpdatable();
            if (updatable || attributeMapping.areEqual(currentValue = naturalId[i], previousValue = previousNaturalId[i], session)) continue;
            throw new HibernateException(String.format("An immutable attribute [%s] within compound natural identifier of entity %s was altered from `%s` to `%s`", attributeMapping.getAttributeName(), persister.getEntityName(), previousValue, currentValue));
        }
    }

    @Override
    public boolean areEqual(Object one, Object other, SharedSessionContractImplementor session) {
        return Arrays.equals((Object[])one, (Object[])other);
    }

    @Override
    public List<SingularAttributeMapping> getNaturalIdAttributes() {
        return this.attributes;
    }

    @Override
    public NaturalIdLoader<?> makeLoader(EntityMappingType entityDescriptor) {
        return new CompoundNaturalIdLoader(this, entityDescriptor);
    }

    @Override
    public MultiNaturalIdLoader<?> makeMultiLoader(EntityMappingType entityDescriptor) {
        return new MultiNaturalIdLoaderStandard(entityDescriptor);
    }

    @Override
    public MappingType getPartMappingType() {
        return this;
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public JavaTypeDescriptor<?> getMappedJavaTypeDescriptor() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        assert (navigablePath.getLocalName().equals("{natural-id}"));
        SessionFactoryImplementor sessionFactory = creationState.getSqlAstCreationState().getCreationContext().getSessionFactory();
        JavaTypeDescriptor<Object[]> jtd = sessionFactory.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Object[].class));
        creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(navigablePath, np -> tableGroup);
        return new DomainResultImpl(navigablePath, this, jtd, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).applySqlSelections(navigablePath, tableGroup, creationState);
        }
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
        }
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        if (domainValue == null) {
            this.attributes.forEach(attributeMapping -> attributeMapping.breakDownJdbcValues(null, valueConsumer, session));
            return;
        }
        assert (domainValue instanceof Object[]);
        Object[] values = (Object[])domainValue;
        assert (values.length == this.attributes.size());
        for (int i = 0; i < this.attributes.size(); ++i) {
            SingularAttributeMapping attributeMapping2 = this.attributes.get(i);
            Object value = values[i];
            if (attributeMapping2 instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOne = (ToOneAttributeMapping)attributeMapping2;
                ForeignKeyDescriptor fKDescriptor = toOne.getForeignKeyDescriptor();
                Object keyValue = value == null ? null : fKDescriptor.disassemble(value, session);
                fKDescriptor.breakDownJdbcValues(keyValue, valueConsumer, session);
                continue;
            }
            attributeMapping2.breakDownJdbcValues(value, valueConsumer, session);
        }
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        int span = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            span += this.attributes.get(i).forEachSelectable(span + offset, consumer);
        }
        return span;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.jdbcMappings.size();
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return this.jdbcMappings;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span;
        for (span = 0; span < this.jdbcMappings.size(); ++span) {
            action.accept(span + offset, this.jdbcMappings.get(span));
        }
        return span;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        assert (value instanceof Object[]);
        Object[] incoming = (Object[])value;
        assert (incoming.length == this.attributes.size());
        Object[] outgoing = new Object[incoming.length];
        for (int i = 0; i < this.attributes.size(); ++i) {
            SingularAttributeMapping attribute = this.attributes.get(i);
            outgoing[i] = attribute.disassemble(incoming[i], session);
        }
        return outgoing;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        assert (value instanceof Object[]);
        Object[] incoming = (Object[])value;
        assert (incoming.length == this.attributes.size());
        int span = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            SingularAttributeMapping attribute = this.attributes.get(i);
            span += attribute.forEachDisassembledJdbcValue(incoming[i], clause, span + offset, valuesConsumer, session);
        }
        return span;
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        assert (value instanceof Object[]);
        Object[] incoming = (Object[])value;
        assert (incoming.length == this.attributes.size());
        int span = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            SingularAttributeMapping attribute = this.attributes.get(i);
            span += attribute.forEachJdbcValue(incoming[i], clause, span + offset, valuesConsumer, session);
        }
        return span;
    }

    @Override
    public int getNumberOfFetchables() {
        return this.attributes.size();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!name.equals(this.attributes.get(i).getAttributeName())) continue;
            return this.attributes.get(i);
        }
        return null;
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.attributes.forEach(consumer);
    }

    private static class InitializerImpl
    implements FetchParentAccess {
        private final NavigablePath navigablePath;
        private final CompoundNaturalIdMapping naturalIdMapping;

        public InitializerImpl(NavigablePath navigablePath, CompoundNaturalIdMapping naturalIdMapping) {
            this.navigablePath = navigablePath;
            this.naturalIdMapping = naturalIdMapping;
        }

        @Override
        public FetchParentAccess findFirstEntityDescriptorAccess() {
            return null;
        }

        @Override
        public Object getParentKey() {
            return null;
        }

        @Override
        public Object getFetchParentInstance() {
            return null;
        }

        @Override
        public NavigablePath getNavigablePath() {
            return this.navigablePath;
        }

        @Override
        public ModelPart getInitializedPart() {
            return this.naturalIdMapping;
        }

        @Override
        public Object getInitializedInstance() {
            return null;
        }

        @Override
        public void resolveKey(RowProcessingState rowProcessingState) {
        }

        @Override
        public void resolveInstance(RowProcessingState rowProcessingState) {
        }

        @Override
        public void initializeInstance(RowProcessingState rowProcessingState) {
        }

        @Override
        public void finishUpRow(RowProcessingState rowProcessingState) {
        }

        @Override
        public void registerResolutionListener(Consumer<Object> resolvedParentConsumer) {
        }
    }

    private static class AssemblerImpl
    implements DomainResultAssembler<Object[]> {
        private final NavigablePath navigablePath;
        private final CompoundNaturalIdMapping naturalIdMapping;
        private final JavaTypeDescriptor<Object[]> jtd;
        private final List<DomainResultAssembler<?>> subAssemblers;

        private AssemblerImpl(List<Fetch> fetches, NavigablePath navigablePath, CompoundNaturalIdMapping naturalIdMapping, JavaTypeDescriptor<Object[]> jtd, AssemblerCreationState creationState) {
            this.navigablePath = navigablePath;
            this.naturalIdMapping = naturalIdMapping;
            this.jtd = jtd;
            InitializerImpl initializer = new InitializerImpl(navigablePath, naturalIdMapping);
            this.subAssemblers = CollectionHelper.arrayList(fetches.size());
            for (int i = 0; i < fetches.size(); ++i) {
                Fetch fetch = fetches.get(i);
                DomainResultAssembler<?> fetchAssembler = fetch.createAssembler(initializer, creationState);
                this.subAssemblers.add(fetchAssembler);
            }
        }

        @Override
        public Object[] assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            Object[] result = new Object[this.subAssemblers.size()];
            for (int i = 0; i < this.subAssemblers.size(); ++i) {
                result[i] = this.subAssemblers.get(i).assemble(rowProcessingState, options);
            }
            return result;
        }

        @Override
        public JavaTypeDescriptor<Object[]> getAssembledJavaTypeDescriptor() {
            return this.jtd;
        }
    }

    public static class DomainResultImpl
    implements DomainResult<Object[]>,
    FetchParent {
        private final NavigablePath navigablePath;
        private final CompoundNaturalIdMapping naturalIdMapping;
        private final JavaTypeDescriptor<Object[]> arrayJtd;
        private final List<Fetch> fetches;
        private final String resultVariable;

        public DomainResultImpl(NavigablePath navigablePath, CompoundNaturalIdMapping naturalIdMapping, JavaTypeDescriptor<Object[]> arrayJtd, String resultVariable, DomainResultCreationState creationState) {
            this.navigablePath = navigablePath;
            this.naturalIdMapping = naturalIdMapping;
            this.arrayJtd = arrayJtd;
            this.resultVariable = resultVariable;
            this.fetches = creationState.visitFetches(this);
        }

        @Override
        public String getResultVariable() {
            return this.resultVariable;
        }

        @Override
        public DomainResultAssembler<Object[]> createResultAssembler(AssemblerCreationState creationState) {
            return new AssemblerImpl(this.fetches, this.navigablePath, this.naturalIdMapping, this.arrayJtd, creationState);
        }

        @Override
        public JavaTypeDescriptor<Object[]> getResultJavaTypeDescriptor() {
            return this.arrayJtd;
        }

        @Override
        public FetchableContainer getReferencedMappingContainer() {
            return this.getReferencedMappingType();
        }

        @Override
        public FetchableContainer getReferencedMappingType() {
            return this.naturalIdMapping;
        }

        @Override
        public NavigablePath getNavigablePath() {
            return this.navigablePath;
        }

        @Override
        public List<Fetch> getFetches() {
            return this.fetches;
        }

        @Override
        public Fetch findFetch(Fetchable fetchable) {
            assert (fetchable != null);
            for (int i = 0; i < this.fetches.size(); ++i) {
                Fetch fetch = this.fetches.get(i);
                if (!fetchable.equals(fetch.getFetchedMapping())) continue;
                return fetch;
            }
            return null;
        }
    }
}

