/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.CompositeTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableFetchImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EmbeddedCollectionPart
implements CollectionPart,
EmbeddableValuedFetchable,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final CollectionPart.Nature nature;
    private final EmbeddableMappingType embeddableMappingType;
    private final String containingTableExpression;
    private final PropertyAccess parentInjectionAttributePropertyAccess;
    private final String sqlAliasStem;

    public EmbeddedCollectionPart(CollectionPersister collectionDescriptor, CollectionPart.Nature nature, EmbeddableMappingType embeddableMappingType, String parentInjectionAttributeName, String containingTableExpression, String sqlAliasStem) {
        this.navigableRole = collectionDescriptor.getNavigableRole().appendContainer(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.nature = nature;
        this.parentInjectionAttributePropertyAccess = parentInjectionAttributeName != null ? PropertyAccessStrategyBasicImpl.INSTANCE.buildPropertyAccess(embeddableMappingType.getMappedJavaTypeDescriptor().getJavaTypeClass(), parentInjectionAttributeName) : null;
        this.embeddableMappingType = embeddableMappingType;
        this.containingTableExpression = containingTableExpression;
        this.sqlAliasStem = sqlAliasStem;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this, resultVariable, creationState);
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public EmbeddableMappingType getEmbeddableTypeDescriptor() {
        return this.embeddableMappingType;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.getEmbeddableTypeDescriptor();
    }

    @Override
    public String getContainingTableExpression() {
        return this.containingTableExpression;
    }

    @Override
    public PropertyAccess getParentInjectionAttributePropertyAccess() {
        return this.parentInjectionAttributePropertyAccess;
    }

    @Override
    public String getFetchableName() {
        return this.getNature().getName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    public String toString() {
        return "EmbeddedCollectionPart(" + this.getNavigableRole() + ")@" + System.identityHashCode(this);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableFetchImpl(fetchablePath, this, fetchParent, FetchTiming.IMMEDIATE, selected, true, creationState);
    }

    @Override
    public SqlTuple toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, SqlAstCreationState sqlAstCreationState) {
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        ArrayList expressions = new ArrayList();
        this.getEmbeddableTypeDescriptor().forEachSelectable((columnIndex, selection) -> {
            assert (this.containingTableExpression.equals(selection.getContainingTableExpression()));
            expressions.add(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(selection.getContainingTableExpression(), selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableGroup.resolveTableReference(tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName()), selection.getContainingTableExpression()), selection, sqlAstCreationState.getCreationContext().getSessionFactory())));
        });
        return new SqlTuple(expressions, this);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        assert (lhs.getModelPart() instanceof PluralAttributeMapping);
        CompositeTableGroup tableGroup = new CompositeTableGroup(navigablePath, this, lhs);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, tableGroup, null);
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.getEmbeddableTypeDescriptor().findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.getEmbeddableTypeDescriptor().visitSubParts(consumer, treatTargetType);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.embeddableMappingType.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.embeddableMappingType.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.getEmbeddableTypeDescriptor().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.getEmbeddableTypeDescriptor().breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }
}

