/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class SelectableMappingsImpl
implements SelectableMappings {
    private final SelectableMapping[] selectableMappings;

    public SelectableMappingsImpl(SelectableMapping[] selectableMappings) {
        this.selectableMappings = selectableMappings;
    }

    private static void resolveJdbcMappings(List<JdbcMapping> jdbcMappings, Mapping mapping, Type valueType) {
        Type keyType = valueType instanceof EntityType ? ((EntityType)valueType).getIdentifierOrUniqueKeyType(mapping) : valueType;
        if (keyType instanceof CompositeType) {
            Type[] subtypes;
            for (Type subtype : subtypes = ((CompositeType)keyType).getSubtypes()) {
                SelectableMappingsImpl.resolveJdbcMappings(jdbcMappings, mapping, subtype);
            }
        } else {
            jdbcMappings.add((JdbcMapping)((Object)keyType));
        }
    }

    public static SelectableMappings from(String containingTableExpression, Value value, int[] propertyOrder, Mapping mapping, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry) {
        ArrayList<JdbcMapping> jdbcMappings = new ArrayList<JdbcMapping>();
        SelectableMappingsImpl.resolveJdbcMappings(jdbcMappings, mapping, value.getType());
        List<Selectable> constraintColumns = value.getSelectables();
        SelectableMapping[] selectableMappings = new SelectableMapping[jdbcMappings.size()];
        for (int i = 0; i < constraintColumns.size(); ++i) {
            selectableMappings[propertyOrder[i]] = SelectableMappingImpl.from(containingTableExpression, constraintColumns.get(i), (JdbcMapping)jdbcMappings.get(propertyOrder[i]), dialect, sqmFunctionRegistry);
        }
        return new SelectableMappingsImpl(selectableMappings);
    }

    public static SelectableMappings from(EmbeddableMappingType embeddableMappingType) {
        int propertySpan = embeddableMappingType.getNumberOfAttributeMappings();
        ArrayList<SelectableMapping> selectableMappings = CollectionHelper.arrayList(propertySpan);
        embeddableMappingType.forEachAttributeMapping((index, attributeMapping) -> attributeMapping.forEachSelectable((columnIndex, selection) -> selectableMappings.add(selection)));
        return new SelectableMappingsImpl(selectableMappings.toArray(new SelectableMapping[0]));
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.selectableMappings[columnIndex];
    }

    @Override
    public int getJdbcTypeCount() {
        return this.selectableMappings.length;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        for (int i = 0; i < this.selectableMappings.length; ++i) {
            consumer.accept(offset + i, this.selectableMappings[i]);
        }
        return this.selectableMappings.length;
    }
}

