/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PropertyBasedMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.NoValueGeneration;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptorSide;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SimpleForeignKeyDescriptor
implements ForeignKeyDescriptor,
BasicValuedModelPart,
FetchOptions {
    private final SimpleForeignKeyDescriptorSide keySide;
    private final SimpleForeignKeyDescriptorSide targetSide;
    private final boolean refersToPrimaryKey;
    private AssociationKey associationKey;

    public SimpleForeignKeyDescriptor(BasicValuedModelPart keyModelPart, PropertyAccess keyPropertyAccess, SelectableMapping keySelectableMapping, BasicValuedModelPart targetModelPart, boolean refersToPrimaryKey) {
        this(keyModelPart, keyPropertyAccess, keySelectableMapping, targetModelPart, refersToPrimaryKey, false);
    }

    public SimpleForeignKeyDescriptor(BasicValuedModelPart keyModelPart, PropertyAccess keyPropertyAccess, SelectableMapping keySelectableMapping, BasicValuedModelPart targetModelPart, boolean refersToPrimaryKey, boolean swapDirection) {
        assert (keySelectableMapping != null);
        assert (targetModelPart != null);
        keyModelPart = BasicAttributeMapping.withSelectableMapping(keyModelPart, keyPropertyAccess, NoValueGeneration.INSTANCE, keySelectableMapping);
        if (swapDirection) {
            this.keySide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, targetModelPart);
            this.targetSide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, keyModelPart);
        } else {
            this.keySide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, keyModelPart);
            this.targetSide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, targetModelPart);
        }
        this.refersToPrimaryKey = refersToPrimaryKey;
    }

    @Override
    public String getKeyTable() {
        return this.keySide.getModelPart().getContainingTableExpression();
    }

    @Override
    public String getTargetTable() {
        return this.targetSide.getModelPart().getContainingTableExpression();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.keySide.getModelPart();
    }

    @Override
    public BasicValuedModelPart getTargetPart() {
        return this.targetSide.getModelPart();
    }

    @Override
    public ForeignKeyDescriptor.Side getKeySide() {
        return this.keySide;
    }

    @Override
    public ForeignKeyDescriptor.Side getTargetSide() {
        return this.targetSide;
    }

    @Override
    public ForeignKeyDescriptor withKeySelectionMapping(IntFunction<SelectableMapping> selectableMappingAccess, MappingModelCreationProcess creationProcess) {
        return new SimpleForeignKeyDescriptor(this.keySide.getModelPart(), ((PropertyBasedMapping)((Object)this.keySide.getModelPart())).getPropertyAccess(), selectableMappingAccess.apply(0), this.targetSide.getModelPart(), this.refersToPrimaryKey);
    }

    @Override
    public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        assert (tableGroup.getTableReference(navigablePath, this.keySide.getModelPart().getContainingTableExpression()) != null);
        return this.createDomainResult(navigablePath, tableGroup, this.keySide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createTargetDomainResult(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        assert (tableGroup.getTableReference(navigablePath, this.targetSide.getModelPart().getContainingTableExpression()) != null);
        return this.createDomainResult(navigablePath, tableGroup, this.targetSide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createCollectionFetchDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        return this.createDomainResult(collectionPath, tableGroup, this.targetSide.getModelPart(), creationState);
    }

    @Override
    public DomainResult<?> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, ForeignKeyDescriptor.Nature side, DomainResultCreationState creationState) {
        if (side == ForeignKeyDescriptor.Nature.KEY) {
            return this.createDomainResult(navigablePath, tableGroup, this.keySide.getModelPart(), creationState);
        }
        return this.createDomainResult(navigablePath, tableGroup, this.targetSide.getModelPart(), creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.createDomainResult(navigablePath, tableGroup, this.keySide.getModelPart(), creationState);
    }

    private <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, SelectableMapping selectableMapping, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath.append(this.getNavigableRole().getNavigableName()), selectableMapping.getContainingTableExpression());
        String identificationVariable = tableReference.getIdentificationVariable();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), s -> new ColumnReference(identificationVariable, selectableMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), selectableMapping.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, selectableMapping.getJdbcMapping().getJavaTypeDescriptor());
    }

    @Override
    public Predicate generateJoinPredicate(TableReference lhs, TableReference rhs, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        if (lhs.getTableReference(this.keySide.getModelPart().getContainingTableExpression()) != null) {
            return new ComparisonPredicate(new ColumnReference(lhs, (SelectableMapping)this.keySide.getModelPart(), creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, (SelectableMapping)this.targetSide.getModelPart(), creationContext.getSessionFactory()));
        }
        return new ComparisonPredicate(new ColumnReference(lhs, (SelectableMapping)this.targetSide.getModelPart(), creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, (SelectableMapping)this.keySide.getModelPart(), creationContext.getSessionFactory()));
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup lhs, TableGroup tableGroup, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference rhsTableKeyReference;
        TableReference lhsTableReference;
        if (this.targetSide.getModelPart().getContainingTableExpression().equals(this.keySide.getModelPart().getContainingTableExpression())) {
            lhsTableReference = this.getTableReferenceWhenTargetEqualsKey(lhs, tableGroup, this.keySide.getModelPart().getContainingTableExpression());
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetSide.getModelPart().getContainingTableExpression());
        } else {
            lhsTableReference = this.getTableReference(lhs, tableGroup, this.keySide.getModelPart().getContainingTableExpression());
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetSide.getModelPart().getContainingTableExpression());
        }
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, sqlAstJoinType, sqlExpressionResolver, creationContext);
    }

    protected TableReference getTableReferenceWhenTargetEqualsKey(TableGroup lhs, TableGroup tableGroup, String table) {
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : lhs.getTableReferenceJoins()) {
            if (!tableJoin.getJoinedTableReference().getTableExpression().equals(table)) continue;
            return tableJoin.getJoinedTableReference();
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    protected TableReference getTableReference(TableGroup lhs, TableGroup tableGroup, String table) {
        NavigablePath navigablePath = lhs.getNavigablePath().append(this.getNavigableRole().getNavigableName());
        if (lhs.getPrimaryTableReference().getTableReference(navigablePath, table) != null) {
            return lhs.getPrimaryTableReference();
        }
        if (tableGroup.getPrimaryTableReference().getTableReference(navigablePath, table) != null) {
            return tableGroup.getPrimaryTableReference();
        }
        TableReference tableReference = lhs.resolveTableReference(navigablePath, table);
        if (tableReference != null) {
            return tableReference;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    @Override
    public MappingType getPartMappingType() {
        return this.targetSide.getModelPart().getMappedType();
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.targetSide.getModelPart().getJdbcMapping().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.targetSide.getModelPart().getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.targetSide.getModelPart().findContainingEntityMapping();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (this.refersToPrimaryKey && value instanceof HibernateProxy) {
            return ((HibernateProxy)value).getHibernateLazyInitializer().getIdentifier();
        }
        return ((PropertyBasedMapping)((Object)this.targetSide.getModelPart())).getPropertyAccess().getGetter().get(value);
    }

    @Override
    public Object getAssociationKeyFromSide(Object targetObject, ForeignKeyDescriptor.Nature nature, SharedSessionContractImplementor session) {
        if (targetObject == null) {
            return null;
        }
        if (this.refersToPrimaryKey && targetObject instanceof HibernateProxy) {
            return ((HibernateProxy)targetObject).getHibernateLazyInitializer().getIdentifier();
        }
        BasicValuedModelPart modelPart = nature == ForeignKeyDescriptor.Nature.KEY ? this.keySide.getModelPart() : this.targetSide.getModelPart();
        return ((PropertyBasedMapping)((Object)modelPart)).getPropertyAccess().getGetter().get(targetObject);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return 1;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this.keySide.getModelPart());
    }

    @Override
    public int visitKeySelectables(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this.keySide.getModelPart());
        return this.getJdbcTypeCount();
    }

    @Override
    public int visitTargetSelectables(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this.targetSide.getModelPart());
        return this.getJdbcTypeCount();
    }

    @Override
    public AssociationKey getAssociationKey() {
        if (this.associationKey == null) {
            List<String> associationKeyColumns = Collections.singletonList(this.keySide.getModelPart().getSelectionExpression());
            this.associationKey = new AssociationKey(this.keySide.getModelPart().getContainingTableExpression(), associationKeyColumns);
        }
        return this.associationKey;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this.targetSide.getModelPart().getJdbcMapping());
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.targetSide.getModelPart().getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.targetSide.getModelPart().getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public String getContainingTableExpression() {
        return this.keySide.getModelPart().getContainingTableExpression();
    }

    @Override
    public String getSelectionExpression() {
        return this.keySide.getModelPart().getSelectionExpression();
    }

    @Override
    public boolean isFormula() {
        return this.keySide.getModelPart().isFormula();
    }

    @Override
    public String getCustomReadExpression() {
        return this.keySide.getModelPart().getCustomReadExpression();
    }

    @Override
    public String getCustomWriteExpression() {
        return this.keySide.getModelPart().getCustomWriteExpression();
    }

    @Override
    public String getFetchableName() {
        return "{fk}";
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return null;
    }

    @Override
    public MappingType getMappedType() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.keySide.getModelPart().getJdbcMapping();
    }

    public String toString() {
        return String.format("SimpleForeignKeyDescriptor : %s.%s -> %s.%s", this.keySide.getModelPart().getContainingTableExpression(), this.keySide.getModelPart().getSelectionExpression(), this.targetSide.getModelPart().getContainingTableExpression(), this.targetSide.getModelPart().getSelectionExpression());
    }
}

