/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.spi;

import java.util.function.Function;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SimpleBasicValueConverter<D, R>
implements BasicValueConverter<D, R> {
    private final JavaTypeDescriptor<D> domainJtd;
    private final JavaTypeDescriptor<R> relationalJtd;
    private final Function<R, D> toDomainHandler;
    private final Function<D, R> toRelationalHandler;

    public SimpleBasicValueConverter(JavaTypeDescriptor<D> domainJtd, JavaTypeDescriptor<R> relationalJtd, Function<R, D> toDomainHandler, Function<D, R> toRelationalHandler) {
        this.domainJtd = domainJtd;
        this.relationalJtd = relationalJtd;
        this.toDomainHandler = toDomainHandler;
        this.toRelationalHandler = toRelationalHandler;
    }

    @Override
    public D toDomainValue(R relationalForm) {
        return this.toDomainHandler.apply(relationalForm);
    }

    @Override
    public R toRelationalValue(D domainForm) {
        return this.toRelationalHandler.apply(domainForm);
    }

    @Override
    public JavaTypeDescriptor<D> getDomainJavaDescriptor() {
        return this.domainJtd;
    }

    @Override
    public JavaTypeDescriptor<R> getRelationalJavaDescriptor() {
        return this.relationalJtd;
    }
}

