/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultBuilderBasicValued;
import org.hibernate.query.results.complete.EntityResultImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitModelPartResultBuilderBasic;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class EntityDomainResultBuilder<T>
implements ResultBuilder {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityDescriptor;
    private final ResultBuilderBasicValued discriminatorResultBuilder;

    public EntityDomainResultBuilder(EntityMappingType entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
        this.navigablePath = new NavigablePath(entityDescriptor.getEntityName());
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        this.discriminatorResultBuilder = discriminatorMapping == null ? null : new ImplicitModelPartResultBuilderBasic(this.navigablePath, discriminatorMapping);
    }

    public EntityResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResult discriminatorResult = this.discriminatorResultBuilder == null ? null : this.discriminatorResultBuilder.buildResult(jdbcResultsMetadata, resultPosition, (BiFunction)legacyFetchResolver, domainResultCreationState);
        return new EntityResultImpl(this.navigablePath, this.entityDescriptor, null, LockMode.NONE, (BasicResult<?>)discriminatorResult, domainResultCreationState);
    }
}

