/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import javax.persistence.ParameterMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.AllowableOutputParameterType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ProcedureCallImplementor;

public class FunctionReturnImpl
implements FunctionReturnImplementor {
    private final ProcedureCallImplementor procedureCall;
    private int jdbcTypeCode;
    private AllowableOutputParameterType<?> ormType;

    public FunctionReturnImpl(ProcedureCallImplementor procedureCall, int jdbcTypeCode) {
        this.procedureCall = procedureCall;
        this.jdbcTypeCode = jdbcTypeCode;
    }

    public FunctionReturnImpl(ProcedureCallImplementor procedureCall, AllowableOutputParameterType ormType) {
        this.procedureCall = procedureCall;
        this.jdbcTypeCode = ormType.getJdbcTypeDescriptor().getJdbcTypeCode();
        this.ormType = ormType;
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcTypeCode;
    }

    @Override
    public AllowableParameterType getHibernateType() {
        return this.ormType;
    }

    public String getName() {
        return null;
    }

    public Integer getPosition() {
        return 0;
    }

    @Override
    public ParameterMode getMode() {
        return ParameterMode.OUT;
    }

    public Class getParameterType() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void disallowMultiValuedBinding() {
    }

    @Override
    public void applyAnticipatedType(AllowableParameterType type) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return false;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> {
            if (this.ormType != null) {
                return new FunctionReturnImpl(this.procedureCall, this.ormType);
            }
            return new FunctionReturnImpl(this.procedureCall, this.jdbcTypeCode);
        };
    }
}

