/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Objects;
import javax.persistence.ParameterMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.AbstractQueryParameter;

public class ProcedureParameterImpl<T>
extends AbstractQueryParameter<T>
implements ProcedureParameterImplementor<T> {
    private final String name;
    private final Integer position;
    private final ParameterMode mode;
    private final Class<T> javaType;

    public ProcedureParameterImpl(String name, ParameterMode mode, Class<T> javaType, AllowableParameterType<T> hibernateType) {
        super(false, hibernateType);
        this.name = name;
        this.position = null;
        this.mode = mode;
        this.javaType = javaType;
    }

    public ProcedureParameterImpl(Integer position, ParameterMode mode, Class<T> javaType, AllowableParameterType<T> hibernateType) {
        super(false, hibernateType);
        this.name = null;
        this.position = position;
        this.mode = mode;
        this.javaType = javaType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public ParameterMode getMode() {
        return this.mode;
    }

    @Override
    public Class<T> getParameterType() {
        return this.javaType;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> {
            if (this.getName() != null) {
                return new ProcedureParameterImpl<T>(this.getName(), this.getMode(), this.javaType, this.getHibernateType());
            }
            return new ProcedureParameterImpl<T>(this.getPosition(), this.getMode(), this.javaType, this.getHibernateType());
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureParameterImpl that = (ProcedureParameterImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.position, that.position) && this.mode == that.mode;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.position, this.mode);
    }

    @Override
    public void prepare(CallableStatement statement, int startIndex, ProcedureCallImplementor<?> procedureCall) throws SQLException {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

