/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.persistence.Parameter;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.procedure.ProcedureParameter;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterImplementor;

public class ProcedureParameterMetadataImpl
implements ParameterMetadataImplementor {
    private ParameterStrategy parameterStrategy = ParameterStrategy.UNKNOWN;
    private List<ProcedureParameterImplementor<?>> parameters;

    public ProcedureParameterMetadataImpl() {
    }

    public ProcedureParameterMetadataImpl(NamedCallableQueryMemento memento, SharedSessionContractImplementor session) {
        memento.getParameterMementos().forEach(parameterMemento -> this.registerParameter(parameterMemento.resolve(session)));
    }

    public void registerParameter(ProcedureParameterImplementor parameter) {
        if (parameter.getName() != null) {
            if (this.parameterStrategy == ParameterStrategy.POSITIONAL) {
                throw new IllegalArgumentException("Cannot mix named parameter with positional parameter registrations");
            }
            this.parameterStrategy = ParameterStrategy.NAMED;
        } else if (parameter.getPosition() != null) {
            if (this.parameterStrategy == ParameterStrategy.NAMED) {
                throw new IllegalArgumentException("Cannot mix positional parameter with named parameter registrations");
            }
            this.parameterStrategy = ParameterStrategy.POSITIONAL;
        } else {
            throw new IllegalArgumentException("Unrecognized parameter type : " + parameter);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
    }

    @Override
    public void visitParameters(Consumer<QueryParameterImplementor<?>> consumer) {
        if (this.parameters != null) {
            this.parameters.forEach(consumer);
        }
    }

    @Override
    public boolean hasNamedParameters() {
        return this.parameterStrategy == ParameterStrategy.NAMED;
    }

    @Override
    public boolean hasPositionalParameters() {
        return this.parameterStrategy == ParameterStrategy.POSITIONAL;
    }

    @Override
    public Set<String> getNamedParameterNames() {
        if (!this.hasNamedParameters()) {
            return Collections.emptySet();
        }
        HashSet<String> rtn = new HashSet<String>();
        for (ProcedureParameter procedureParameter : this.parameters) {
            if (procedureParameter.getName() == null) continue;
            rtn.add(procedureParameter.getName());
        }
        return rtn;
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    public boolean containsReference(QueryParameter parameter) {
        return this.parameters.contains(parameter);
    }

    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    @Override
    public boolean hasAnyMatching(Predicate<QueryParameterImplementor<?>> filter) {
        if (this.parameters.isEmpty()) {
            return false;
        }
        for (ProcedureParameterImplementor<?> parameter : this.parameters) {
            if (!filter.test(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ProcedureParameterImplementor<?> getQueryParameter(String name) {
        for (ProcedureParameterImplementor<?> parameter : this.parameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public ProcedureParameterImplementor<?> getQueryParameter(int positionLabel) {
        for (ProcedureParameterImplementor<?> parameter : this.parameters) {
            if (parameter.getName() != null || positionLabel != parameter.getPosition()) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public ProcedureParameterImplementor<?> resolve(Parameter param) {
        if (param instanceof ProcedureParameterImplementor) {
            return (ProcedureParameterImplementor)param;
        }
        return null;
    }

    @Override
    public Set<? extends QueryParameter<?>> getRegistrations() {
        return (Set)((Object)this.parameters);
    }

    @Override
    public void visitRegistrations(Consumer<? extends QueryParameter<?>> action) {
        this.parameters.forEach(action);
    }

    @Override
    public Set<Integer> getOrdinalParameterLabels() {
        HashSet<Integer> labels = new HashSet<Integer>();
        this.visitRegistrations(p -> {
            if (p.getPosition() != null) {
                labels.add(p.getPosition());
            }
        });
        return labels;
    }
}

