/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Locale;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;

public class QualifiedJoinPredicatePathConsumer
extends BasicDotIdentifierConsumer {
    private final SqmQualifiedJoin sqmJoin;

    public QualifiedJoinPredicatePathConsumer(SqmQualifiedJoin sqmJoin, SqmCreationState creationState) {
        super(creationState);
        this.sqmJoin = sqmJoin;
    }

    @Override
    protected SemanticPathPart createBasePart() {
        return new BasicDotIdentifierConsumer.BaseLocalSequencePart(){

            @Override
            protected void validateAsRoot(SqmFrom pathRoot) {
                if (pathRoot.findRoot() != QualifiedJoinPredicatePathConsumer.this.sqmJoin.findRoot()) {
                    throw new SemanticException(String.format(Locale.ROOT, "SqmQualifiedJoin predicate referred to SqmRoot [`%s`] other than the join's root [`%s`]", pathRoot.getNavigablePath().getFullPath(), QualifiedJoinPredicatePathConsumer.this.sqmJoin.getNavigablePath().getFullPath()));
                }
                super.validateAsRoot(pathRoot);
            }
        };
    }
}

