/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;

public class QueryHelper {
    private QueryHelper() {
    }

    @SafeVarargs
    public static <T> SqmExpressable<? extends T> highestPrecedenceType(SqmExpressable<? extends T> ... types) {
        if (types == null || types.length == 0) {
            return null;
        }
        if (types.length == 1) {
            return types[0];
        }
        SqmExpressable<? extends T> highest = QueryHelper.highestPrecedenceType2(types[0], types[1]);
        for (int i = 2; i < types.length; ++i) {
            highest = QueryHelper.highestPrecedenceType2(highest, types[i]);
        }
        return highest;
    }

    public static <X> SqmExpressable<? extends X> highestPrecedenceType2(SqmExpressable<? extends X> type1, SqmExpressable<? extends X> type2) {
        if (type1 == null && type2 == null) {
            return null;
        }
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1 instanceof SqmPathSource) {
            return type1;
        }
        if (type2 instanceof SqmPathSource) {
            return type2;
        }
        return type1;
    }
}

