/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sql.spi.ParameterInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.stat.spi.StatisticsImplementor;

public class QueryInterpretationCacheDisabledImpl
implements QueryInterpretationCache {
    private final Supplier<StatisticsImplementor> statisticsSupplier;

    public QueryInterpretationCacheDisabledImpl(Supplier<StatisticsImplementor> statisticsSupplier) {
        this.statisticsSupplier = statisticsSupplier;
    }

    @Override
    public int getNumberOfCachedHqlInterpretations() {
        return 0;
    }

    @Override
    public int getNumberOfCachedQueryPlans() {
        return 0;
    }

    @Override
    public SelectQueryPlan resolveSelectQueryPlan(QueryInterpretationCache.Key key, Supplier<SelectQueryPlan> creator) {
        return null;
    }

    @Override
    public NonSelectQueryPlan getNonSelectQueryPlan(QueryInterpretationCache.Key key) {
        return null;
    }

    @Override
    public void cacheNonSelectQueryPlan(QueryInterpretationCache.Key key, NonSelectQueryPlan plan) {
    }

    @Override
    public HqlInterpretation resolveHqlInterpretation(String queryString, Function<String, SqmStatement<?>> creator) {
        ParameterMetadataImpl parameterMetadata;
        DomainParameterXref domainParameterXref;
        StatisticsImplementor statistics = this.statisticsSupplier.get();
        boolean stats = statistics.isStatisticsEnabled();
        long startTime = stats ? System.nanoTime() : 0L;
        final SqmStatement<?> sqmStatement = creator.apply(queryString);
        if (sqmStatement.getSqmParameters().isEmpty()) {
            domainParameterXref = DomainParameterXref.empty();
            parameterMetadata = ParameterMetadataImpl.EMPTY;
        } else {
            domainParameterXref = DomainParameterXref.from(sqmStatement);
            parameterMetadata = new ParameterMetadataImpl(domainParameterXref.getQueryParameters());
        }
        if (stats) {
            long endTime = System.nanoTime();
            long microseconds = TimeUnit.MICROSECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.queryCompiled(queryString, microseconds);
        }
        return new HqlInterpretation(){

            @Override
            public SqmStatement getSqmStatement() {
                return sqmStatement;
            }

            @Override
            public ParameterMetadataImplementor getParameterMetadata() {
                return parameterMetadata;
            }

            @Override
            public DomainParameterXref getDomainParameterXref() {
                return domainParameterXref;
            }
        };
    }

    @Override
    public ParameterInterpretation resolveNativeQueryParameters(String queryString, Function<String, ParameterInterpretation> creator) {
        return creator.apply(queryString);
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void close() {
    }
}

