/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.FetchMemento;
import org.hibernate.query.named.ResultMementoBasic;
import org.hibernate.query.named.ResultMementoEntity;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultBuilderBasicValued;
import org.hibernate.query.results.ResultBuilderEntityValued;
import org.hibernate.query.results.complete.CompleteResultBuilderEntityStandard;

public class ResultMementoEntityStandard
implements ResultMementoEntity,
FetchMemento.Parent {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityDescriptor;
    private final LockMode lockMode;
    private final ResultMementoBasic discriminatorMemento;
    private final Map<String, FetchMemento> fetchMementoMap;

    public ResultMementoEntityStandard(EntityMappingType entityDescriptor, LockMode lockMode, ResultMementoBasic discriminatorMemento, Map<String, FetchMemento> fetchMementoMap) {
        this.navigablePath = new NavigablePath(entityDescriptor.getEntityName());
        this.entityDescriptor = entityDescriptor;
        this.lockMode = lockMode;
        this.discriminatorMemento = discriminatorMemento;
        this.fetchMementoMap = fetchMementoMap;
        QueryLogging.QUERY_LOGGER.debugf("Created ResultMementoEntityStandard - %s", (Object)this.navigablePath);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ResultBuilderEntityValued resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        ResultBuilder discriminatorResultBuilder = this.discriminatorMemento != null ? this.discriminatorMemento.resolve((Consumer)querySpaceConsumer, context) : null;
        HashMap<String, FetchBuilder> fetchBuilderMap = new HashMap<String, FetchBuilder>();
        this.fetchMementoMap.forEach((attrName, fetchMemento) -> fetchBuilderMap.put((String)attrName, fetchMemento.resolve(this, querySpaceConsumer, context)));
        return new CompleteResultBuilderEntityStandard(this.navigablePath, this.entityDescriptor, this.lockMode, (ResultBuilderBasicValued)discriminatorResultBuilder, fetchBuilderMap);
    }
}

