/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;

public class EntityResultImpl
implements EntityResult {
    private final NavigablePath navigablePath;
    private final EntityValuedModelPart entityValuedModelPart;
    private final DomainResult identifierResult;
    private final BasicResult discriminatorResult;
    private final List<Fetch> fetches;
    private final String resultAlias;
    private final LockMode lockMode;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultAlias, LockMode lockMode, BasicResult<?> discriminatorResult, DomainResultCreationState creationState) {
        this.navigablePath = navigablePath;
        this.entityValuedModelPart = entityValuedModelPart;
        this.resultAlias = resultAlias;
        this.lockMode = lockMode;
        this.discriminatorResult = discriminatorResult;
        this.fetches = creationState.visitFetches(this);
        EntityIdentifierMapping identifierMapping = entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
        String idAttributeName = identifierMapping instanceof SingleAttributeIdentifierMapping ? ((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName() : null;
        MutableObject<Fetch> idFetchRef = new MutableObject<Fetch>();
        for (int i = 0; i < this.fetches.size(); ++i) {
            Fetch fetch = this.fetches.get(i);
            String fetchLocalName = fetch.getNavigablePath().getLocalName();
            if (!fetchLocalName.equals("{id}") && (idAttributeName == null || !fetchLocalName.equals(idAttributeName))) continue;
            idFetchRef.set(fetch);
            this.fetches.remove(i);
            break;
        }
        this.identifierResult = idFetchRef.isNotSet() ? ResultsHelper.implicitIdentifierResult(identifierMapping, new EntityIdentifierNavigablePath(navigablePath, ResultsHelper.attributeName(identifierMapping)), creationState) : ((Fetch)idFetchRef.get()).asResult(creationState);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EntityValuedModelPart getReferencedMappingType() {
        return this.entityValuedModelPart;
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.entityValuedModelPart;
    }

    @Override
    public String getResultVariable() {
        return this.resultAlias;
    }

    @Override
    public List<Fetch> getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        for (int i = 0; i < this.fetches.size(); ++i) {
            if (this.fetches.get(i).getFetchedMapping() != fetchable) continue;
            return this.fetches.get(i);
        }
        return null;
    }

    public DomainResultAssembler createResultAssembler(AssemblerCreationState creationState) {
        EntityInitializer initializer = (EntityInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> new EntityResultInitializer((EntityResultGraphNode)this, this.getNavigablePath(), this.lockMode, this.identifierResult, (DomainResult)this.discriminatorResult, null, null, creationState));
        return new EntityAssembler(this.getResultJavaTypeDescriptor(), initializer);
    }
}

