/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicFetchBuilderStandard
implements DynamicFetchBuilder,
NativeQuery.ReturnProperty {
    private final DynamicFetchBuilderContainer container;
    private final String fetchableName;
    private final List<String> columnNames = new ArrayList<String>();

    public DynamicFetchBuilderStandard(DynamicFetchBuilderContainer container, String fetchableName) {
        this.container = container;
        this.fetchableName = fetchableName;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup ownerTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        Fetchable attributeMapping = (Fetchable)parent.getReferencedMappingContainer().findSubPart(this.fetchableName, null);
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        SelectableConsumer selectableConsumer = (selectionIndex, selectableMapping) -> {
            TableReference tableReference = ownerTableGroup.getTableReference(fetchPath, selectableMapping.getContainingTableExpression());
            String columnAlias = this.columnNames.get(selectionIndex);
            sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), state -> {
                int resultSetPosition = jdbcResultsMetadata.resolveColumnPosition(columnAlias);
                int valuesArrayPosition = resultSetPosition - 1;
                return new SqlSelectionImpl(valuesArrayPosition, (BasicValuedMapping)((Object)selectableMapping));
            }), selectableMapping.getJdbcMapping().getMappedJavaTypeDescriptor(), domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        };
        if (attributeMapping instanceof BasicValuedMapping) {
            attributeMapping.forEachSelectable(selectableConsumer);
            return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.IMMEDIATE, true, null, creationStateImpl);
        }
        assert (attributeMapping instanceof ToOneAttributeMapping);
        ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
        toOneAttributeMapping.getForeignKeyDescriptor().visitKeySelectables(selectableConsumer);
        return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.DELAYED, false, null, creationStateImpl);
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        this.columnNames.add(columnAlias);
        return this;
    }
}

