/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.Locale;
import java.util.function.BiFunction;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilder;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicResultBuilderAttribute
implements DynamicResultBuilder,
NativeQuery.ReturnProperty {
    private final BasicAttributeMapping attributeMapping;
    private final String columnAlias;
    private final String entityName;
    private final String attributePath;

    public DynamicResultBuilderAttribute(SingularAttributeMapping attributeMapping, String columnAlias, String entityName, String attributePath) {
        boolean allowable = attributeMapping instanceof BasicAttributeMapping;
        if (!allowable) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Specified attribute [%s.%s] must be basic: %s", entityName, attributePath, attributeMapping));
        }
        this.attributeMapping = (BasicAttributeMapping)attributeMapping;
        this.columnAlias = columnAlias;
        this.entityName = entityName;
        this.attributePath = attributePath;
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(this.columnAlias, state -> {
            int resultSetPosition = jdbcResultsMetadata.resolveColumnPosition(this.columnAlias);
            int valuesArrayPosition = resultSetPosition - 1;
            return new SqlSelectionImpl(valuesArrayPosition, this.attributeMapping);
        }), this.attributeMapping.getJavaTypeDescriptor(), domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), this.columnAlias, this.attributeMapping.getJavaTypeDescriptor(), this.attributeMapping.getValueConverter());
    }
}

