/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.function.BiFunction;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultBuilderEmbeddable;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitModelPartResultBuilder;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitModelPartResultBuilderEmbeddable
implements ImplicitModelPartResultBuilder,
ResultBuilderEmbeddable {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart modelPart;

    public ImplicitModelPartResultBuilderEmbeddable(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
    }

    @Override
    public EmbeddableResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        creationStateImpl.disallowPositionalSelections();
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().resolveTableGroup(this.navigablePath, np -> {
            if (this.navigablePath.getParent() == null) {
                throw new IllegalStateException("Could not determine LHS for implicit embeddable result builder - " + this.navigablePath);
            }
            TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(this.navigablePath.getParent());
            TableGroupJoin tableGroupJoin = this.modelPart.createTableGroupJoin(this.navigablePath, parentTableGroup, null, SqlAstJoinType.INNER, true, creationStateImpl);
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        return (EmbeddableResult)this.modelPart.createDomainResult(this.navigablePath, tableGroup, null, domainResultCreationState);
    }
}

