/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmAggregateFunction;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractSqmFunctionDescriptor
implements SqmFunctionDescriptor {
    private final ArgumentsValidator argumentsValidator;
    private final FunctionReturnTypeResolver returnTypeResolver;
    private final String name;

    protected FunctionReturnTypeResolver getReturnTypeResolver() {
        return this.returnTypeResolver;
    }

    public AbstractSqmFunctionDescriptor(String name) {
        this(name, null, null);
    }

    public AbstractSqmFunctionDescriptor(String name, ArgumentsValidator argumentsValidator) {
        this(name, argumentsValidator, null);
    }

    public AbstractSqmFunctionDescriptor(String name, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        this.name = name;
        this.argumentsValidator = argumentsValidator == null ? StandardArgumentsValidators.NONE : argumentsValidator;
        this.returnTypeResolver = returnTypeResolver == null ? StandardFunctionReturnTypeResolvers.useFirstNonNull() : returnTypeResolver;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSignature(String name) {
        return this.getReturnSignature() + name + this.getArgumentListSignature();
    }

    public String getReturnSignature() {
        String result = this.returnTypeResolver.getReturnType();
        return result.isEmpty() ? "" : result + " ";
    }

    public String getArgumentListSignature() {
        String args = this.argumentsValidator.getSignature();
        return this.alwaysIncludesParentheses() ? args : ("()".equals(args) ? "" : "[" + args + "]");
    }

    private static SqlAstNode toSqlAstNode(Object arg, SqmToSqlAstConverter walker) {
        return (SqlAstNode)arg;
    }

    public static List<SqlAstNode> resolveSqlAstArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        if (sqmArguments == null || sqmArguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>();
        for (SqmTypedNode<?> sqmArgument : sqmArguments) {
            sqlAstArguments.add(AbstractSqmFunctionDescriptor.toSqlAstNode(((SqmVisitableNode)((Object)sqmArgument)).accept(walker), walker));
        }
        return sqlAstArguments;
    }

    @Override
    public final <T> SelfRenderingSqmFunction<T> generateSqmExpression(List<? extends SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        this.argumentsValidator.validate(arguments);
        return this.generateSqmFunctionExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
    }

    @Override
    public final <T> SelfRenderingSqmFunction<T> generateAggregateSqmExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        this.argumentsValidator.validate(arguments);
        return this.generateSqmAggregateFunctionExpression(arguments, filter, impliedResultType, queryEngine, typeConfiguration);
    }

    protected abstract <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> var1, AllowableFunctionReturnType<T> var2, QueryEngine var3, TypeConfiguration var4);

    protected <T> SelfRenderingSqmAggregateFunction<T> generateSqmAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return (SelfRenderingSqmAggregateFunction)this.generateSqmExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
    }
}

