/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import java.util.Locale;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class NamedSqmFunctionDescriptor
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final String functionName;
    private final boolean useParenthesesWhenNoArgs;
    private final String argumentListSignature;
    private final SqlAstNodeRenderingMode argumentRenderingMode;

    public NamedSqmFunctionDescriptor(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        this(functionName, useParenthesesWhenNoArgs, argumentsValidator, returnTypeResolver, functionName, false, null, SqlAstNodeRenderingMode.DEFAULT);
    }

    public NamedSqmFunctionDescriptor(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, String name, boolean isAggregate, String argumentListSignature, SqlAstNodeRenderingMode argumentRenderingMode) {
        super(name, isAggregate, argumentsValidator, returnTypeResolver);
        this.functionName = functionName;
        this.useParenthesesWhenNoArgs = useParenthesesWhenNoArgs;
        this.argumentListSignature = argumentListSignature;
        this.argumentRenderingMode = argumentRenderingMode;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public String getArgumentListSignature() {
        return this.argumentListSignature == null ? super.getArgumentListSignature() : this.argumentListSignature;
    }

    @Override
    public boolean alwaysIncludesParentheses() {
        return this.useParenthesesWhenNoArgs;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> sqlAstArguments, SqlAstTranslator<?> translator) {
        this.render(sqlAppender, sqlAstArguments, null, translator);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> sqlAstArguments, Predicate filter, SqlAstTranslator<?> translator) {
        boolean useParens = this.useParenthesesWhenNoArgs || !sqlAstArguments.isEmpty();
        boolean caseWrapper = filter != null && !translator.supportsFilterClause();
        sqlAppender.appendSql(this.functionName);
        if (useParens) {
            sqlAppender.appendSql("(");
        }
        boolean firstPass = true;
        for (SqlAstNode arg : sqlAstArguments) {
            if (!firstPass) {
                sqlAppender.appendSql(", ");
            }
            if (caseWrapper && !(arg instanceof Distinct)) {
                sqlAppender.appendSql("case when ");
                filter.accept(translator);
                sqlAppender.appendSql(" then ");
                if (arg instanceof Star) {
                    sqlAppender.appendSql("1");
                } else {
                    translator.render(arg, this.argumentRenderingMode);
                }
                sqlAppender.appendSql(" else null end");
            } else {
                translator.render(arg, this.argumentRenderingMode);
            }
            firstPass = false;
        }
        if (useParens) {
            sqlAppender.appendSql(")");
        }
        if (filter != null && !caseWrapper) {
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "NamedSqmFunctionTemplate(%s)", this.functionName);
    }
}

