/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.function.BiFunction;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.RootClass;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SqmMutationStrategyHelper {
    public static final SqmMutationStrategyHelper INSTANCE = new SqmMutationStrategyHelper();

    private SqmMutationStrategyHelper() {
    }

    public static SqmMultiTableMutationStrategy resolveStrategy(RootClass entityBootDescriptor, EntityMappingType rootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        SessionFactoryOptions options = sessionFactory.getSessionFactoryOptions();
        SqmMultiTableMutationStrategy specifiedStrategy = options.getCustomSqmMultiTableMutationStrategy();
        if (specifiedStrategy != null) {
            return specifiedStrategy;
        }
        return sessionFactory.getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect().getFallbackSqmMutationStrategy(rootEntityDescriptor, creationContext);
    }

    public static void cleanUpCollectionTables(EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        if (!entityDescriptor.getEntityPersister().hasCollections()) {
            return;
        }
        entityDescriptor.visitAttributeMappings(attributeMapping -> {
            if (attributeMapping instanceof PluralAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTable((PluralAttributeMapping)attributeMapping, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            }
        });
    }

    private static void cleanUpCollectionTable(PluralAttributeMapping attributeMapping, EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        String separateCollectionTable = attributeMapping.getSeparateCollectionTable();
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        if (separateCollectionTable != null) {
            TableReference tableReference = new TableReference(separateCollectionTable, null, true, sessionFactory);
            DeleteStatement sqlAstDelete = new DeleteStatement(tableReference, restrictionProducer.apply(tableReference, attributeMapping));
            jdbcServices.getJdbcMutationExecutor().execute(jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildDeleteTranslator(sessionFactory, sqlAstDelete).translate(jdbcParameterBindings, executionContext.getQueryOptions()), jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, SqlOmittingQueryOptions.omitSqlQueryOptions(executionContext));
        }
    }
}

