/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.cte.AbstractCteMutationHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteStrategy;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;

public class CteDeleteHandler
extends AbstractCteMutationHandler
implements DeleteHandler {
    protected CteDeleteHandler(SqmCteTable cteTable, SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, CteStrategy strategy, SessionFactoryImplementor sessionFactory) {
        super(cteTable, sqmDeleteStatement, domainParameterXref, strategy, sessionFactory);
    }

    @Override
    protected void addDmlCtes(CteContainer statement, CteStatement idSelectCte, MultiTableSqmMutationConverter sqmConverter, Map<SqmParameter, List<JdbcParameter>> parameterResolutions, SessionFactoryImplementor factory) {
        TableGroup updatingTableGroup = sqmConverter.getMutatingTableGroup();
        this.getEntityDescriptor().visitAttributeMappings(attribute -> {
            PluralAttributeMapping pluralAttribute;
            if (attribute instanceof PluralAttributeMapping && (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null) {
                String tableExpression = pluralAttribute.getSeparateCollectionTable();
                CteTable dmlResultCte = new CteTable("dml_cte_" + tableExpression, idSelectCte.getCteTable().getCteColumns(), factory);
                TableReference dmlTableReference = new TableReference(tableExpression, null, true, factory);
                ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
                pluralAttribute.getKeyDescriptor().visitKeySelectables((index, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, selectable, factory)));
                DeleteStatement dmlStatement = new DeleteStatement(dmlTableReference, this.createIdSubQueryPredicate(columnReferences, idSelectCte, factory), columnReferences);
                statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
            }
        });
        this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableColumnsVisitationSupplier) -> {
            CteTable dmlResultCte = new CteTable("dml_cte_" + tableExpression, idSelectCte.getCteTable().getCteColumns(), factory);
            TableReference dmlTableReference = this.resolveUnionTableReference(updatingTableGroup, tableExpression);
            ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
            ((Consumer)tableColumnsVisitationSupplier.get()).accept((index, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, selectable, factory)));
            DeleteStatement dmlStatement = new DeleteStatement(dmlTableReference, this.createIdSubQueryPredicate(columnReferences, idSelectCte, factory), columnReferences);
            statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
        });
    }
}

