/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;

class TableKeyExpressionCollector {
    private final EntityMappingType entityMappingType;
    Expression firstColumnExpression;
    List<Expression> collectedColumnExpressions;

    TableKeyExpressionCollector(EntityMappingType entityMappingType) {
        this.entityMappingType = entityMappingType;
    }

    void apply(ColumnReference columnReference) {
        if (this.firstColumnExpression == null) {
            this.firstColumnExpression = columnReference;
        } else if (this.collectedColumnExpressions == null) {
            this.collectedColumnExpressions = new ArrayList<Expression>();
            this.collectedColumnExpressions.add(this.firstColumnExpression);
            this.collectedColumnExpressions.add(columnReference);
        } else {
            this.collectedColumnExpressions.add(columnReference);
        }
    }

    Expression buildKeyExpression() {
        if (this.collectedColumnExpressions == null) {
            return this.firstColumnExpression;
        }
        return new SqlTuple(this.collectedColumnExpressions, this.entityMappingType.getIdentifierMapping());
    }
}

