/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class EntityValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements SqlTupleContainer {
    private final Expression sqlExpression;

    public static <T> EntityValuedPathInterpretation<T> from(SqmEntityValuedSimplePath<T> sqmPath, SqmToSqlAstConverter sqlAstCreationState) {
        JpaPath<T> realPath = CollectionPart.Nature.ELEMENT.getName().equals(sqmPath.getNavigablePath().getUnaliasedLocalName()) ? sqmPath.getLhs() : sqmPath;
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(realPath.getLhs().getNavigablePath());
        EntityValuedModelPart mapping = (EntityValuedModelPart)sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath()).getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        return EntityValuedPathInterpretation.from(sqmPath.getNavigablePath(), tableGroup, mapping, false, sqlAstCreationState);
    }

    public static <T> EntityValuedPathInterpretation<T> from(NavigablePath navigablePath, TableGroup tableGroup, EntityValuedModelPart mapping, boolean expandToAllColumns, SqmToSqlAstConverter sqlAstCreationState) {
        Expression sqlExpression;
        SqlExpressionResolver sqlExprResolver = sqlAstCreationState.getSqlExpressionResolver();
        SessionFactoryImplementor sessionFactory = sqlAstCreationState.getCreationContext().getSessionFactory();
        if (expandToAllColumns) {
            EntityMappingType entityMappingType = mapping.getEntityMappingType();
            EntityIdentifierMapping identifierMapping = entityMappingType.getIdentifierMapping();
            EntityDiscriminatorMapping discriminatorMapping = entityMappingType.getDiscriminatorMapping();
            ArrayList expressions = new ArrayList(mapping.getJdbcTypeCount() + identifierMapping.getJdbcTypeCount() + (discriminatorMapping == null ? 0 : 1));
            SelectableConsumer selectableConsumer = (selectionIndex, selectableMapping) -> {
                TableReference tableReference = tableGroup.resolveTableReference(navigablePath, selectableMapping.getContainingTableExpression());
                expressions.add(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, sessionFactory)));
            };
            identifierMapping.forEachSelectable(selectableConsumer);
            if (discriminatorMapping != null) {
                discriminatorMapping.forEachSelectable(selectableConsumer);
            }
            mapping.forEachSelectable(selectableConsumer);
            sqlExpression = new SqlTuple(expressions, mapping);
        } else if (mapping instanceof EntityAssociationMapping) {
            ModelPart lhsPart;
            String lhsTable;
            EntityAssociationMapping associationMapping = (EntityAssociationMapping)((Object)mapping);
            ForeignKeyDescriptor fkDescriptor = associationMapping.getForeignKeyDescriptor();
            if (associationMapping.getSideNature() == ForeignKeyDescriptor.Nature.KEY) {
                lhsTable = fkDescriptor.getKeyTable();
                lhsPart = fkDescriptor.getKeyPart();
            } else {
                lhsTable = fkDescriptor.getTargetTable();
                lhsPart = fkDescriptor.getTargetPart();
            }
            TableReference tableReference = tableGroup.resolveTableReference(navigablePath, lhsTable);
            if (fkDescriptor instanceof SimpleForeignKeyDescriptor) {
                BasicValuedModelPart basicValuedModelPart = (BasicValuedModelPart)lhsPart;
                sqlExpression = sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, basicValuedModelPart.getSelectionExpression()), processingState -> new ColumnReference(tableReference, (SelectableMapping)basicValuedModelPart, sessionFactory));
            } else {
                ArrayList expressions = new ArrayList(fkDescriptor.getJdbcTypeCount());
                lhsPart.forEachSelectable((selectionIndex, selectableMapping) -> expressions.add(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, sessionFactory))));
                sqlExpression = new SqlTuple(expressions, lhsPart);
            }
        } else {
            assert (mapping instanceof EntityMappingType);
            EntityMappingType entityMappingType = (EntityMappingType)mapping;
            EntityIdentifierMapping identifierMapping = entityMappingType.getIdentifierMapping();
            if (identifierMapping instanceof BasicEntityIdentifierMapping) {
                BasicEntityIdentifierMapping simpleIdMapping = (BasicEntityIdentifierMapping)identifierMapping;
                TableReference tableReference = tableGroup.resolveTableReference(navigablePath, simpleIdMapping.getContainingTableExpression());
                assert (tableReference != null) : "Could not resolve table-group : " + simpleIdMapping.getContainingTableExpression();
                sqlExpression = sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, simpleIdMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, (SelectableMapping)simpleIdMapping, sessionFactory));
            } else {
                ArrayList expressions = new ArrayList();
                identifierMapping.forEachSelectable((selectionIndex, selectableMapping) -> {
                    TableReference tableReference = tableGroup.resolveTableReference(navigablePath, selectableMapping.getContainingTableExpression());
                    expressions.add(sqlExprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping.getSelectionExpression()), processingState -> new ColumnReference(tableReference, selectableMapping, sessionFactory)));
                });
                sqlExpression = new SqlTuple(expressions, identifierMapping);
            }
        }
        return new EntityValuedPathInterpretation<T>(sqlExpression, navigablePath, tableGroup, mapping);
    }

    public EntityValuedPathInterpretation(Expression sqlExpression, NavigablePath navigablePath, TableGroup tableGroup, EntityValuedModelPart mapping) {
        super(navigablePath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
    }

    @Override
    public Expression getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlExpression instanceof SqlTuple ? (SqlTuple)this.sqlExpression : null;
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this.sqlExpression, this.getExpressionType().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public EntityValuedModelPart getExpressionType() {
        return (EntityValuedModelPart)super.getExpressionType();
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        EntityValuedModelPart mappingType = this.getExpressionType();
        if (mappingType instanceof EntityAssociationMapping) {
            NavigablePath navigablePath = this.getNavigablePath();
            SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
            FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
            EntityAssociationMapping associationMapping = (EntityAssociationMapping)((Object)mappingType);
            TableGroup tableGroup = fromClauseAccess.resolveTableGroup(navigablePath, np -> {
                TableGroup parentTableGroup = this.getExpressionType() instanceof CollectionPart ? fromClauseAccess.findTableGroup(np.getParent().getParent()) : this.getTableGroup();
                TableGroupJoin tableGroupJoin = associationMapping.createTableGroupJoin(navigablePath, parentTableGroup, null, SqlAstJoinType.INNER, false, sqlAstCreationState);
                return tableGroupJoin.getJoinedGroup();
            });
            return associationMapping.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
        }
        return super.createDomainResult(resultVariable, creationState);
    }
}

