/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.List;
import java.util.function.Function;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;

public class SqmParameterInterpretation
implements Expression,
DomainResultProducer,
SqlTupleContainer {
    private final SqmParameter sqmParameter;
    private final QueryParameterImplementor<?> queryParameter;
    private final MappingModelExpressable valueMapping;
    private final Function<QueryParameterImplementor, QueryParameterBinding> queryParameterBindingResolver;
    private final Expression resolvedExpression;

    public SqmParameterInterpretation(SqmParameter sqmParameter, QueryParameterImplementor<?> queryParameter, List<JdbcParameter> jdbcParameters, MappingModelExpressable valueMapping, Function<QueryParameterImplementor, QueryParameterBinding> queryParameterBindingResolver) {
        this.sqmParameter = sqmParameter;
        this.queryParameter = queryParameter;
        this.queryParameterBindingResolver = queryParameterBindingResolver;
        this.valueMapping = valueMapping instanceof EntityValuedFetchable ? ((EntityValuedFetchable)valueMapping).getEntityMappingType().getIdentifierMapping() : valueMapping;
        assert (jdbcParameters != null);
        assert (jdbcParameters.size() > 0);
        this.resolvedExpression = this.determineResolvedExpression(jdbcParameters, this.valueMapping);
    }

    private Expression determineResolvedExpression(List<JdbcParameter> jdbcParameters, MappingModelExpressable valueMapping) {
        if (valueMapping instanceof EmbeddableValuedModelPart || valueMapping instanceof DiscriminatedAssociationModelPart) {
            return new SqlTuple(jdbcParameters, valueMapping);
        }
        assert (jdbcParameters.size() == 1);
        return jdbcParameters.get(0);
    }

    public Expression getResolvedExpression() {
        return this.resolvedExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.resolvedExpression.accept(sqlTreeWalker);
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this.valueMapping;
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        if (this.resolvedExpression instanceof SqlTuple) {
            throw new SemanticException("Composite query parameter cannot be used in select");
        }
        AllowableParameterType nodeType = this.sqmParameter.getNodeType();
        if (nodeType == null) {
            QueryParameterBinding binding = this.queryParameterBindingResolver.apply(this.queryParameter);
            nodeType = binding.getBindType();
        }
        SqlSelection sqlSelection = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this.resolvedExpression, nodeType.getExpressableJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, nodeType.getExpressableJavaTypeDescriptor());
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.resolvedExpression instanceof SqlTuple ? (SqlTuple)this.resolvedExpression : null;
    }
}

