/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.ParameterCollector;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public abstract class AbstractSqmStatement<T>
extends AbstractSqmNode
implements SqmStatement<T>,
ParameterCollector {
    private final SqmQuerySource querySource;
    private Set<SqmParameter<?>> parameters;

    public AbstractSqmStatement(SqmQuerySource querySource, NodeBuilder builder) {
        super(builder);
        this.querySource = querySource;
    }

    @Override
    public SqmQuerySource getQuerySource() {
        return this.querySource;
    }

    @Override
    public void addParameter(SqmParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        this.parameters.add(parameter);
    }

    @Override
    public Set<SqmParameter<?>> getSqmParameters() {
        return this.parameters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.parameters);
    }

    @Override
    public SqmStatement.ParameterResolutions resolveParameters() {
        return new SqmStatement.ParameterResolutions(){

            @Override
            public Set<SqmParameter<?>> getSqmParameters() {
                return AbstractSqmStatement.this.getSqmParameters();
            }

            @Override
            public Map<JpaCriteriaParameter<?>, Supplier<SqmJpaCriteriaParameterWrapper<?>>> getJpaCriteriaParamResolutions() {
                return Collections.emptyMap();
            }
        };
    }
}

