/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.BasicType;

public abstract class AbstractSqmPath<T>
extends AbstractSqmExpression<T>
implements SqmPath<T> {
    private final NavigablePath navigablePath;
    private final SqmPath<?> lhs;
    private Map<String, SqmPath<?>> reusablePaths;

    protected AbstractSqmPath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        super(referencedPathSource, nodeBuilder);
        this.navigablePath = navigablePath;
        this.lhs = lhs;
    }

    @Override
    public SqmPathSource<T> getNodeType() {
        return (SqmPathSource)super.getNodeType();
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        return (SqmPathSource)super.getNodeType();
    }

    protected AbstractSqmPath(SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        this(lhs == null ? new NavigablePath(referencedPathSource.getPathName()) : lhs.getNavigablePath().append(referencedPathSource.getPathName()), referencedPathSource, lhs, nodeBuilder);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public SqmPath<?> getLhs() {
        return this.lhs;
    }

    @Override
    public List<SqmPath<?>> getReusablePaths() {
        if (this.reusablePaths == null) {
            return Collections.emptyList();
        }
        return new ArrayList(this.reusablePaths.values());
    }

    @Override
    public void visitReusablePaths(Consumer<SqmPath<?>> consumer) {
        if (this.reusablePaths != null) {
            this.reusablePaths.values().forEach(consumer);
        }
    }

    @Override
    public void registerReusablePath(SqmPath<?> path) {
        String relativeName;
        SqmPath<?> previous;
        assert (path.getLhs() == this);
        if (this.reusablePaths == null) {
            this.reusablePaths = new HashMap();
        }
        if ((previous = this.reusablePaths.put(relativeName = path.getNavigablePath().getLocalName(), path)) != null && previous != path) {
            throw new IllegalStateException("Implicit-join path registration unexpectedly overrode previous registration - " + relativeName);
        }
    }

    @Override
    public SqmPath<?> getReusablePath(String name) {
        if (this.reusablePaths == null) {
            return null;
        }
        return this.reusablePaths.get(name);
    }

    @Override
    public String getExplicitAlias() {
        return this.getAlias();
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        this.setAlias(explicitAlias);
    }

    public SqmPathSource<T> getModel() {
        return this.getReferencedPathSource();
    }

    public SqmExpression<Class<? extends T>> type() {
        return this.get("{discriminator}");
    }

    public SqmPath<?> get(String attributeName) {
        if (this.getReferencedPathSource().getSqmPathType() instanceof BasicType) {
            throw new IllegalStateException("Cannot resolve path `" + attributeName + "` relative to a basic-valued path: `" + this.getNavigablePath() + "`");
        }
        SqmPathSource<?> subNavigable = this.getReferencedPathSource().findSubPathSource(attributeName);
        if (subNavigable == null) {
            throw new IllegalArgumentException("Could not resolve attribute named `" + attributeName + "` relative to `" + this.getNavigablePath() + "`");
        }
        return this.resolvePath(attributeName, subNavigable);
    }

    private SqmPath<?> resolvePath(PersistentAttribute<?, ?> attribute) {
        return this.resolvePath(attribute.getName(), (SqmPathSource)((Object)attribute));
    }

    private SqmPath<?> resolvePath(String attributeName, SqmPathSource<?> pathSource) {
        if (this.reusablePaths == null) {
            this.reusablePaths = new HashMap();
            SqmPath<?> path = pathSource.createSqmPath(this);
            this.reusablePaths.put(attributeName, path);
            return path;
        }
        return this.reusablePaths.computeIfAbsent(attributeName, name -> pathSource.createSqmPath(this));
    }

    public <Y> SqmPath<Y> get(SingularAttribute<? super T, Y> jpaAttribute) {
        return this.resolvePath((PersistentAttribute)jpaAttribute);
    }

    public <E, C extends Collection<E>> SqmPath<C> get(PluralAttribute<T, C, E> attribute) {
        return this.resolvePath((PersistentAttribute)attribute);
    }

    public <K, V, M extends Map<K, V>> SqmPath<M> get(MapAttribute<T, K, V> map) {
        return this.resolvePath((PersistentAttribute)map);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath.getFullPath() + ")";
    }
}

