/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.PathException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public interface SqmPath<T>
extends SqmExpression<T>,
SemanticPathPart,
JpaPath<T> {
    @Override
    public NavigablePath getNavigablePath();

    public SqmPathSource<?> getReferencedPathSource();

    public String getExplicitAlias();

    public void setExplicitAlias(String var1);

    @Override
    public SqmPath<?> getLhs();

    public List<SqmPath<?>> getReusablePaths();

    public void visitReusablePaths(Consumer<SqmPath<?>> var1);

    public void registerReusablePath(SqmPath<?> var1);

    public SqmPath<?> getReusablePath(String var1);

    @Override
    public SqmPathSource<T> getNodeType();

    @Override
    default public void applyInferableType(SqmExpressable<?> type) {
    }

    @Override
    default public JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        return this.getNodeType().getExpressableJavaTypeDescriptor();
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> var1) throws PathException;

    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> var1) throws PathException;

    default public SqmRoot findRoot() {
        JpaPath lhs = this.getLhs();
        if (lhs != null) {
            return lhs.findRoot();
        }
        throw new ParsingException("Could not find root");
    }

    @Override
    default public SqmPath resolveIndexedAccess(SqmExpression selector, boolean isTerminal, SqmCreationState creationState) {
        throw new SemanticException("Non-plural path [" + this.getNavigablePath() + "] cannot be index-accessed");
    }
}

