/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmTreatedRoot<T, S extends T>
extends SqmRoot<S>
implements SqmTreatedPath<T, S> {
    private final SqmRoot<T> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedRoot(SqmRoot<T> wrappedPath, EntityDomainType<S> treatTarget, NodeBuilder nodeBuilder) {
        super(wrappedPath.getNavigablePath(), wrappedPath.getReferencedPathSource(), (String)null, nodeBuilder);
        this.wrappedPath = wrappedPath;
        this.treatTarget = treatTarget;
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getManagedType() {
        return this.getTreatTarget();
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public EntityDomainType<S> getReferencedPathSource() {
        return this.getManagedType();
    }

    @Override
    public SqmPath<?> getLhs() {
        return this.wrappedPath.getLhs();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitTreatedPath(this);
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        NavigablePath subNavPath = this.getNavigablePath().append(name);
        return creationState.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(subNavPath, snp -> {
            SqmPathSource subSource = creationState.getCreationOptions().useStrictJpaCompliance() ? this.getManagedType().findSubPathSource(name) : this.treatTarget.findSubPathSource(name);
            if (subSource == null) {
                throw UnknownPathException.unknownSubPath(this, name);
            }
            return subSource.createSqmPath(this);
        });
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

