/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.jpa.AbstractJpaSelection;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractSqmExpression<T>
extends AbstractJpaSelection<T>
implements SqmExpression<T> {
    public AbstractSqmExpression(SqmExpressable<T> type, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
    }

    @Override
    public final void applyInferableType(SqmExpressable<?> type) {
    }

    protected void internalApplyInferableType(SqmExpressable<?> newType) {
        SqmTreeCreationLogger.LOGGER.debugf("Applying inferable type to SqmExpression [%s] : %s -> %s", (Object)this, this.getNodeType(), newType);
        this.setExpressableType(QueryHelper.highestPrecedenceType(newType, this.getNodeType()));
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.castAs(StandardBasicTypes.LONG);
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.castAs(StandardBasicTypes.INTEGER);
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.castAs(StandardBasicTypes.FLOAT);
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.castAs(StandardBasicTypes.DOUBLE);
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return this.castAs(StandardBasicTypes.BIG_DECIMAL);
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return this.castAs(StandardBasicTypes.BIG_INTEGER);
    }

    @Override
    public SqmExpression<String> asString() {
        return this.castAs(StandardBasicTypes.STRING);
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)type);
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull(this);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull(this);
    }

    @Override
    public SqmPredicate in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmPredicate in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, (Expression[])values);
    }

    @Override
    public SqmPredicate in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, new Object[]{values});
    }

    @Override
    public SqmPredicate in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public JpaSelection<T> alias(String name) {
        this.setAlias(name);
        return this;
    }

    @Override
    public JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        return this.getNodeType().getExpressableJavaTypeDescriptor();
    }
}

