/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;

public class SqmBetweenPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> expression;
    private final SqmExpression<?> lowerBound;
    private final SqmExpression<?> upperBound;

    public SqmBetweenPredicate(SqmExpression<?> expression, SqmExpression<?> lowerBound, SqmExpression<?> upperBound, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.expression = expression;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        SqmExpressable expressableType = QueryHelper.highestPrecedenceType(expression.getNodeType(), lowerBound.getNodeType(), upperBound.getNodeType());
        expression.applyInferableType(expressableType);
        lowerBound.applyInferableType(expressableType);
        upperBound.applyInferableType(expressableType);
    }

    public SqmExpression<?> getExpression() {
        return this.expression;
    }

    public SqmExpression<?> getLowerBound() {
        return this.lowerBound;
    }

    public SqmExpression<?> getUpperBound() {
        return this.upperBound;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitBetweenPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.expression.appendHqlString(sb);
        if (this.isNegated()) {
            sb.append(" not");
        }
        sb.append(" between ");
        this.lowerBound.appendHqlString(sb);
        sb.append(" and ");
        this.upperBound.appendHqlString(sb);
    }
}

