/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmInSubQueryPredicate<T>
extends AbstractNegatableSqmPredicate
implements SqmInPredicate<T> {
    private final SqmExpression<T> testExpression;
    private final SqmSubQuery<T> subQueryExpression;

    public SqmInSubQueryPredicate(SqmExpression<T> testExpression, SqmSubQuery<T> subQueryExpression, NodeBuilder nodeBuilder) {
        this(testExpression, subQueryExpression, false, nodeBuilder);
    }

    public SqmInSubQueryPredicate(SqmExpression<T> testExpression, SqmSubQuery<T> subQueryExpression, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.testExpression = testExpression;
        this.subQueryExpression = subQueryExpression;
        SqmExpressable<T> expressableType = QueryHelper.highestPrecedenceType2(testExpression.getNodeType(), subQueryExpression.getNodeType());
        testExpression.applyInferableType(expressableType);
        subQueryExpression.applyInferableType(expressableType);
    }

    @Override
    public SqmExpression<T> getTestExpression() {
        return this.testExpression;
    }

    @Override
    public SqmExpression<T> getExpression() {
        return this.getTestExpression();
    }

    public SqmSubQuery<T> getSubQueryExpression() {
        return this.subQueryExpression;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitInSubQueryPredicate(this);
    }

    @Override
    public SqmInPredicate<T> value(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqmInPredicate<T> value(Expression value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqmInPredicate<T> value(JpaExpression<? extends T> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.testExpression.appendHqlString(sb);
        if (this.isNegated()) {
            sb.append(" not");
        }
        sb.append(" in ");
        this.subQueryExpression.appendHqlString(sb);
    }
}

