/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;

public class SqmMemberOfPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression leftHandExpression;
    private final SqmPath<?> pluralPath;

    public SqmMemberOfPredicate(SqmExpression leftHandExpression, SqmPath<?> pluralPath, NodeBuilder nodeBuilder) {
        this(leftHandExpression, pluralPath, false, nodeBuilder);
    }

    public SqmMemberOfPredicate(SqmExpression leftHandExpression, SqmPath pluralPath, boolean negated, NodeBuilder nodeBuilder) {
        super(negated, nodeBuilder);
        this.pluralPath = pluralPath;
        this.leftHandExpression = leftHandExpression;
    }

    public SqmExpression getLeftHandExpression() {
        return this.leftHandExpression;
    }

    public SqmPath<?> getPluralPath() {
        return this.pluralPath;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitMemberOfPredicate(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.leftHandExpression.appendHqlString(sb);
        if (this.isNegated()) {
            sb.append(" not");
        }
        sb.append(" member of ");
        this.pluralPath.appendHqlString(sb);
    }
}

