/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.jpa.ParameterCollector;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmSelectStatement<T>
extends AbstractSqmSelectQuery<T>
implements JpaCriteriaQuery<T>,
SqmStatement<T>,
org.hibernate.query.sqm.internal.ParameterCollector {
    private final SqmQuerySource querySource;
    private Set<SqmParameter<?>> parameters;

    public SqmSelectStatement(NodeBuilder nodeBuilder) {
        this(SqmQuerySource.HQL, nodeBuilder);
    }

    public SqmSelectStatement(SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(null, nodeBuilder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(Class<T> resultJavaType, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(resultJavaType, nodeBuilder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(SqmQueryPart<T> queryPart, Class<T> resultType, SqmQuerySource querySource, NodeBuilder builder) {
        super(queryPart, resultType, builder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(Class<T> resultJavaType, NodeBuilder nodeBuilder) {
        super(resultJavaType, nodeBuilder);
        this.querySource = SqmQuerySource.CRITERIA;
        ((SqmQuerySpec)this.getQuerySpec()).setSelectClause(new SqmSelectClause(false, nodeBuilder));
        ((SqmQuerySpec)this.getQuerySpec()).setFromClause(new SqmFromClause());
    }

    @Override
    public SqmQuerySource getQuerySource() {
        return this.querySource;
    }

    @Override
    public SqmQuerySpec<T> getQuerySpec() {
        if (this.querySource == SqmQuerySource.CRITERIA) {
            JpaQueryPart queryPart = this.getQueryPart();
            if (queryPart instanceof SqmQuerySpec) {
                return (SqmQuerySpec)queryPart;
            }
            throw new IllegalStateException("Query group can't be treated as query spec. Use JpaSelectCriteria#getQueryPart to access query group details");
        }
        return super.getQuerySpec();
    }

    public boolean containsCollectionFetches() {
        return this.containsCollectionFetches((SqmQueryPart<?>)this.getQueryPart());
    }

    private boolean containsCollectionFetches(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            return ((SqmQuerySpec)queryPart).containsCollectionFetches();
        }
        SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
        return this.containsCollectionFetches(queryGroup.getQueryParts().get(0));
    }

    public boolean usesDistinct() {
        return this.usesDistinct((SqmQueryPart<?>)this.getQueryPart());
    }

    private boolean usesDistinct(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            return ((SqmQuerySpec)queryPart).getSelectClause().isDistinct();
        }
        SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
        return this.usesDistinct(queryGroup.getQueryParts().get(0));
    }

    @Override
    public Set<SqmParameter<?>> getSqmParameters() {
        if (this.querySource == SqmQuerySource.CRITERIA) {
            assert (this.parameters == null) : "SqmSelectStatement (as Criteria) should not have collected parameters";
            return ParameterCollector.collectParameters(this, sqmParameter -> {}, this.nodeBuilder().getServiceRegistry());
        }
        return this.parameters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.parameters);
    }

    @Override
    public SqmStatement.ParameterResolutions resolveParameters() {
        if (this.querySource == SqmQuerySource.CRITERIA) {
            CriteriaParameterCollector parameterCollector = new CriteriaParameterCollector();
            ParameterCollector.collectParameters(this, parameterCollector::process, this.nodeBuilder().getServiceRegistry());
            return parameterCollector.makeResolution();
        }
        return new SqmStatement.ParameterResolutions(){

            @Override
            public Set<SqmParameter<?>> getSqmParameters() {
                return SqmSelectStatement.this.parameters == null ? Collections.emptySet() : Collections.unmodifiableSet(SqmSelectStatement.this.parameters);
            }

            @Override
            public Map<JpaCriteriaParameter<?>, Supplier<SqmJpaCriteriaParameterWrapper<?>>> getJpaCriteriaParamResolutions() {
                return Collections.emptyMap();
            }
        };
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSelectStatement(this);
    }

    @Override
    public void addParameter(SqmParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        this.parameters.add(parameter);
    }

    @Override
    public SqmSelectStatement<T> distinct(boolean distinct) {
        return (SqmSelectStatement)super.distinct(distinct);
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        assert (this.querySource == SqmQuerySource.CRITERIA);
        return this.getSqmParameters();
    }

    @Override
    public SqmSelectStatement<T> select(Selection<? extends T> selection) {
        ((SqmQuerySpec)this.getQuerySpec()).setSelection((JpaSelection)selection);
        if (this.getResultType() == null) {
            this.setResultType(selection.getJavaType());
        }
        return this;
    }

    @Override
    public SqmSelectStatement<T> multiselect(Selection<?> ... selections) {
        for (Selection<?> selection : selections) {
            ((SqmQuerySpec)this.getQuerySpec()).getSelectClause().add((SqmExpression)selection, selection.getAlias());
        }
        if (this.getResultType() == null) {
            this.setResultType(Object[].class);
        }
        return this;
    }

    @Override
    public SqmSelectStatement<T> multiselect(List<Selection<?>> selectionList) {
        for (Selection<?> selection : selectionList) {
            ((SqmQuerySpec)this.getQuerySpec()).getSelectClause().add((SqmExpression)selection, selection.getAlias());
        }
        if (this.getResultType() == null) {
            this.setResultType(Object[].class);
        }
        return this;
    }

    @Override
    public SqmSelectStatement<T> orderBy(Order ... orders) {
        if (((SqmQueryPart)this.getQueryPart()).getOrderByClause() == null) {
            ((SqmQueryPart)this.getQueryPart()).setOrderByClause(new SqmOrderByClause());
        }
        for (Order order : orders) {
            ((SqmQueryPart)this.getQueryPart()).getOrderByClause().addSortSpecification((SqmSortSpecification)order);
        }
        return this;
    }

    @Override
    public SqmSelectStatement<T> orderBy(List<Order> orders) {
        if (((SqmQueryPart)this.getQueryPart()).getOrderByClause() == null) {
            ((SqmQueryPart)this.getQueryPart()).setOrderByClause(new SqmOrderByClause());
        }
        for (Order order : orders) {
            ((SqmQueryPart)this.getQueryPart()).getOrderByClause().addSortSpecification((SqmSortSpecification)order);
        }
        return this;
    }

    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public SqmSelectStatement<T> where(Expression<Boolean> restriction) {
        return (SqmSelectStatement)super.where((Expression)restriction);
    }

    @Override
    public SqmSelectStatement<T> where(Predicate ... restrictions) {
        return (SqmSelectStatement)super.where(restrictions);
    }

    @Override
    public SqmSelectStatement<T> groupBy(Expression<?> ... expressions) {
        return (SqmSelectStatement)super.groupBy((Expression[])expressions);
    }

    @Override
    public SqmSelectStatement<T> groupBy(List<Expression<?>> grouping) {
        return (SqmSelectStatement)super.groupBy((List)grouping);
    }

    @Override
    public SqmSelectStatement<T> having(Expression<Boolean> booleanExpression) {
        return (SqmSelectStatement)super.having((Expression)booleanExpression);
    }

    @Override
    public SqmSelectStatement<T> having(Predicate ... predicates) {
        return (SqmSelectStatement)super.having(predicates);
    }

    @Override
    public JpaExpression<Number> getOffset() {
        return ((SqmQueryPart)this.getQueryPart()).getOffset();
    }

    @Override
    public JpaCriteriaQuery<T> offset(JpaExpression<? extends Number> offset) {
        ((SqmQueryPart)this.getQueryPart()).setOffset((JpaExpression)offset);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> offset(Number offset) {
        ((SqmQueryPart)this.getQueryPart()).setOffset(this.nodeBuilder().value(offset));
        return this;
    }

    @Override
    public JpaExpression<Number> getFetch() {
        return ((SqmQueryPart)this.getQueryPart()).getFetch();
    }

    @Override
    public JpaCriteriaQuery<T> fetch(JpaExpression<? extends Number> fetch) {
        ((SqmQueryPart)this.getQueryPart()).setFetch((JpaExpression)fetch);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(JpaExpression<? extends Number> fetch, FetchClauseType fetchClauseType) {
        ((SqmQueryPart)this.getQueryPart()).setFetch(fetch, fetchClauseType);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(Number fetch) {
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch));
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(Number fetch, FetchClauseType fetchClauseType) {
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch), fetchClauseType);
        return this;
    }

    @Override
    public FetchClauseType getFetchClauseType() {
        return ((SqmQueryPart)this.getQueryPart()).getFetchClauseType();
    }

    private static class ParameterResolutionsImpl
    implements SqmStatement.ParameterResolutions {
        private final Set<SqmParameter<?>> sqmParameters;
        private final Map<JpaCriteriaParameter<?>, Supplier<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;

        public ParameterResolutionsImpl(Set<SqmParameter<?>> sqmParameters, Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions) {
            this.sqmParameters = sqmParameters;
            if (jpaCriteriaParamResolutions == null || jpaCriteriaParamResolutions.isEmpty()) {
                this.jpaCriteriaParamResolutions = Collections.emptyMap();
            } else {
                this.jpaCriteriaParamResolutions = new IdentityHashMap(CollectionHelper.determineProperSizing(jpaCriteriaParamResolutions));
                for (Map.Entry<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> entry : jpaCriteriaParamResolutions.entrySet()) {
                    Iterator<SqmJpaCriteriaParameterWrapper<?>> itr = entry.getValue().iterator();
                    this.jpaCriteriaParamResolutions.put(entry.getKey(), () -> {
                        if (itr.hasNext()) {
                            return (SqmJpaCriteriaParameterWrapper)itr.next();
                        }
                        throw new IllegalStateException("SqmJpaCriteriaParameterWrapper references for JpaCriteriaParameter [" + entry.getKey() + "] already exhausted");
                    });
                }
            }
        }

        @Override
        public Set<SqmParameter<?>> getSqmParameters() {
            return this.sqmParameters;
        }

        @Override
        public Map<JpaCriteriaParameter<?>, Supplier<SqmJpaCriteriaParameterWrapper<?>>> getJpaCriteriaParamResolutions() {
            return this.jpaCriteriaParamResolutions;
        }
    }

    private static class CriteriaParameterCollector {
        private Set<SqmParameter<?>> sqmParameters;
        private Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;

        private CriteriaParameterCollector() {
        }

        public void process(SqmParameter<?> parameter) {
            if (this.sqmParameters == null) {
                this.sqmParameters = new HashSet();
            }
            if (parameter instanceof SqmJpaCriteriaParameterWrapper) {
                if (this.jpaCriteriaParamResolutions == null) {
                    this.jpaCriteriaParamResolutions = new IdentityHashMap();
                }
                SqmJpaCriteriaParameterWrapper wrapper = (SqmJpaCriteriaParameterWrapper)parameter;
                JpaCriteriaParameter criteriaParameter = wrapper.getJpaCriteriaParameter();
                List sqmParametersForCriteriaParameter = this.jpaCriteriaParamResolutions.computeIfAbsent(criteriaParameter, jcp -> new ArrayList());
                sqmParametersForCriteriaParameter.add(wrapper);
                this.sqmParameters.add(wrapper);
            } else {
                if (parameter instanceof JpaCriteriaParameter) {
                    throw new UnsupportedOperationException();
                }
                this.sqmParameters.add(parameter);
            }
        }

        private SqmStatement.ParameterResolutions makeResolution() {
            return new ParameterResolutionsImpl(this.sqmParameters == null ? Collections.emptySet() : this.sqmParameters, this.jpaCriteriaParamResolutions == null ? Collections.emptyMap() : this.jpaCriteriaParamResolutions);
        }
    }
}

